/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.eltorito.impl;

import com.github.stephenc.javaisotools.eltorito.impl.ElToritoConfig;
import com.github.stephenc.javaisotools.eltorito.impl.ElToritoFactory;
import com.github.stephenc.javaisotools.eltorito.impl.ElToritoLayoutHelper;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Element;
import com.github.stephenc.javaisotools.iso9660.impl.LogicalSectorElement;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.LSBFWordDataReference;
import com.github.stephenc.javaisotools.iso9660.volumedescriptors.BootRecord;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.ChainingStreamHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class ElToritoHandler
extends ChainingStreamHandler {
    private ElToritoConfig config;
    private Fixup bootCatalogLocation;
    private Fixup bootImageLocation;

    public ElToritoHandler(StreamHandler streamHandler, ElToritoConfig config) {
        super(streamHandler, streamHandler);
        this.config = config;
    }

    @Override
    public void startElement(Element element) throws HandlerException {
        if (element instanceof ISO9660Element) {
            String id = (String)element.getId();
            this.process(id);
        }
        super.startElement(element);
    }

    private void process(String id) throws HandlerException {
        if (id.equals("VDS")) {
            this.doBVD();
        } else if (id.equals("BIA")) {
            this.doCatalog();
        }
        if (id.equals("BDA")) {
            this.doImage();
        }
    }

    private void doBVD() throws HandlerException {
        super.startElement(new LogicalSectorElement("BR"));
        ElToritoLayoutHelper helper = new ElToritoLayoutHelper(this);
        BootRecord br = new BootRecord(this, helper);
        br.setMetadata(this.config);
        br.doBR();
        this.bootCatalogLocation = this.fixup(new LSBFWordDataReference(0L));
        super.endElement();
    }

    private void doCatalog() throws HandlerException {
        super.startElement(new LogicalSectorElement("BCAT"));
        long position = this.mark();
        int location = (int)(position / 2048L);
        this.bootCatalogLocation.data(new LSBFWordDataReference(location));
        this.bootCatalogLocation.close();
        ElToritoFactory etf = new ElToritoFactory(this);
        int platformID = this.config.getPlatformID();
        String idString = this.config.getIDString();
        etf.doValidationEntry(platformID, idString);
        boolean bootable = this.config.getBootable();
        int bootMediaType = this.config.getBootMediaType();
        int loadSegment = this.config.getLoadSegment();
        int systemType = this.config.getSystemType();
        int sectorCount = this.config.getSectorCount();
        this.bootImageLocation = etf.doDefaultEntry(bootable, bootMediaType, loadSegment, systemType, sectorCount);
        super.endElement();
    }

    private void doImage() throws HandlerException {
        super.startElement(new LogicalSectorElement("BIMG"));
        long position = this.mark();
        int location = (int)(position / 2048L);
        this.bootImageLocation.data(new LSBFWordDataReference(location));
        this.bootImageLocation.close();
        if (this.config.getGenBootInfoTable()) {
            this.genBootInfoTable(location);
        }
        this.data(this.config.getBootImage().getDataReference());
        super.endElement();
    }

    private void genBootInfoTable(int lba) throws HandlerException {
        try {
            String orgName = this.config.getBootImage().getAbsolutePath();
            File orgFile = new File(orgName);
            FileInputStream fis = new FileInputStream(orgFile);
            fis.skip(64L);
            long checksum = 0L;
            byte[] buffer = new byte[8192];
            while (fis.available() > 0) {
                int len = fis.read(buffer);
                int i2 = 0;
                while (i2 < len) {
                    long temp = buffer[i2++] & 0xFF;
                    temp |= (long)(buffer[i2++] << 8 & 0xFF00);
                    temp |= (long)(buffer[i2++] << 16 & 0xFF0000);
                    checksum += (temp |= (long)(buffer[i2++] << 24) & 0xFF000000L);
                }
            }
            fis.close();
            fis = new FileInputStream(orgFile);
            File patchedFile = new File(orgName + ".mod");
            FileOutputStream fos = new FileOutputStream(patchedFile);
            buffer = new byte[8];
            fis.read(buffer);
            fos.write(buffer);
            buffer = new byte[56];
            fis.read(buffer);
            Arrays.fill(buffer, (byte)0);
            int i3 = 0;
            int pvd = 16;
            buffer[i3++] = (byte)(pvd & 0xFF);
            buffer[i3++] = (byte)(pvd >> 8 & 0xFF);
            buffer[i3++] = (byte)(pvd >> 16 & 0xFF);
            buffer[i3++] = (byte)(pvd >> 24 & 0xFF);
            buffer[i3++] = (byte)(lba & 0xFF);
            buffer[i3++] = (byte)(lba >> 8 & 0xFF);
            buffer[i3++] = (byte)(lba >> 16 & 0xFF);
            buffer[i3++] = (byte)(lba >> 24 & 0xFF);
            int len = (int)this.config.getBootImage().length();
            buffer[i3++] = (byte)(len & 0xFF);
            buffer[i3++] = (byte)(len >> 8 & 0xFF);
            buffer[i3++] = (byte)(len >> 16 & 0xFF);
            buffer[i3++] = (byte)(len >> 24 & 0xFF);
            buffer[i3++] = (byte)(checksum & 0xFFL);
            buffer[i3++] = (byte)(checksum >> 8 & 0xFFL);
            buffer[i3++] = (byte)(checksum >> 16 & 0xFFL);
            buffer[i3++] = (byte)(checksum >> 24 & 0xFFL);
            fos.write(buffer);
            buffer = new byte[8192];
            while (fis.available() > 0) {
                len = fis.read(buffer);
                fos.write(buffer, 0, len);
            }
            fis.close();
            fos.close();
            orgFile.delete();
            orgFile = new File(orgName);
            patchedFile.renameTo(orgFile);
            this.config.setBootImage(new ISO9660File(orgFile));
            System.out.println("Patched boot image at " + orgFile.getPath());
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }
}

