/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.rockridge.impl;

import com.github.stephenc.javaisotools.iso9660.impl.ISO9660DateDataReference;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660ShortDateDataReference;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.BothWordDataReference;
import com.github.stephenc.javaisotools.rockridge.impl.SUSPFactory;
import com.github.stephenc.javaisotools.rockridge.impl.SystemUseEntryElement;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;
import com.github.stephenc.javaisotools.sabre.impl.ByteDataReference;

public class RRIPFactory
extends SUSPFactory {
    public static boolean MKISOFS_COMPATIBILITY = true;
    public static final int CR_CONTINUES = 1;
    public static final int CR_CURRENT = 2;
    public static final int CR_PARENT = 4;
    public static final int CR_ROOT = 8;
    public static final int NM_CONTINUES = 1;
    public static final int NM_CURRENT = 2;
    public static final int NM_PARENT = 4;
    public static final int TF_CREATION = 1;
    public static final int TF_MODIFY = 2;
    public static final int TF_ACCESS = 4;
    public static final int TF_ATTRIBUTES = 8;
    public static final int TF_BACKUP = 16;
    public static final int TF_EXPIRATION = 32;
    public static final int TF_EFFECTIVE = 64;
    public static final int TF_LONG_FORM = 128;
    public static final int RR_PX_RECORDED = 1;
    public static final int RR_PN_RECORDED = 2;
    public static final int RR_SL_RECORDED = 4;
    public static final int RR_NM_RECORDED = 8;
    public static final int RR_CL_RECORDED = 16;
    public static final int RR_PL_RECORDED = 32;
    public static final int RR_RE_RECORDED = 64;
    public static final int RR_TF_RECORDED = 128;
    public static final int NM_ENTRY_LENGTH = 5;

    public RRIPFactory(StreamHandler streamHandler) {
        super(streamHandler);
    }

    public void doPXEntry(int fileModes, int fileLinks, int uid, int gid, long serialNumber) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("PX", 1));
        this.streamHandler.data(new BothWordDataReference(fileModes));
        this.streamHandler.data(new BothWordDataReference(fileLinks));
        this.streamHandler.data(new BothWordDataReference(uid));
        this.streamHandler.data(new BothWordDataReference(gid));
        if (!MKISOFS_COMPATIBILITY) {
            this.streamHandler.data(new BothWordDataReference(serialNumber));
        }
        this.streamHandler.endElement();
    }

    public void doPNEntry(int deviceNumberHigh, int deviceNumberLow) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("PN", 1));
        this.streamHandler.data(new BothWordDataReference(deviceNumberHigh));
        this.streamHandler.data(new BothWordDataReference(deviceNumberLow));
        this.streamHandler.endElement();
    }

    public void startSLEntry(boolean continues) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("SL", 1));
        this.streamHandler.data(new ByteDataReference(continues ? 1L : 0L));
    }

    public void doComponentRecord(int flags) throws HandlerException {
        if (flags != 1 && flags != 2 && flags != 4 && flags != 8) {
            throw new HandlerException("Invalid Rock Ridge Component Record flags combination: " + flags);
        }
        this.streamHandler.data(new ByteDataReference(flags));
        this.streamHandler.data(new ByteDataReference(0L));
    }

    public void doComponentRecord(DataReference name) throws HandlerException {
        this.streamHandler.data(new ByteDataReference(0L));
        this.streamHandler.data(new ByteDataReference(name.getLength()));
        this.streamHandler.data(name);
    }

    public void endSLEntry() throws HandlerException {
        this.streamHandler.endElement();
    }

    public void doNMEntry(int flags, DataReference name) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("NM", 1));
        if (flags != 0 && flags != 1 && flags != 2 && flags != 4) {
            throw new HandlerException("Invalid Rock Ridge directory flags combination: " + flags);
        }
        this.streamHandler.data(new ByteDataReference(flags));
        this.streamHandler.data(name);
        this.streamHandler.endElement();
    }

    public Fixup doCLEntry() throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("CL", 1));
        Fixup childLocationFixup = this.streamHandler.fixup(new BothWordDataReference(0L));
        this.streamHandler.endElement();
        return childLocationFixup;
    }

    public Fixup doPLEntry() throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("PL", 1));
        Fixup parentLocationFixup = this.streamHandler.fixup(new BothWordDataReference(0L));
        this.streamHandler.endElement();
        return parentLocationFixup;
    }

    public void doREEntry() throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("RE", 1));
        this.streamHandler.endElement();
    }

    public void doTFEntry(int type, ISO9660DateDataReference date) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("TF", 1));
        this.checkTFType(type);
        this.streamHandler.data(new ByteDataReference(type | 0x80));
        this.streamHandler.data(date);
        this.streamHandler.endElement();
    }

    public void doTFEntry(int type, ISO9660ShortDateDataReference date) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("TF", 1));
        this.checkTFType(type);
        this.streamHandler.data(new ByteDataReference(type));
        this.streamHandler.data(date);
        this.streamHandler.endElement();
    }

    private void checkTFType(int type) throws HandlerException {
        if (type != 1 && type != 2 && type != 4 && type != 8 && type != 16 && type != 32 && type != 64) {
            throw new HandlerException("Invalid Rock Ridge Timestamp type: " + type);
        }
    }

    public void doSFEntry(long virtualFileSizeHigh, long virtualFileSizeLow, int tableDepth) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("SF", 1));
        this.streamHandler.data(new BothWordDataReference(virtualFileSizeHigh));
        this.streamHandler.data(new BothWordDataReference(virtualFileSizeLow));
        this.streamHandler.data(new ByteDataReference(tableDepth));
        this.streamHandler.endElement();
    }

    public void doEREntry() throws HandlerException {
        String source;
        String descriptor;
        String id;
        if (MKISOFS_COMPATIBILITY) {
            id = "RRIP_1991A";
            descriptor = "THE ROCK RIDGE INTERCHANGE PROTOCOL PROVIDES SUPPORT FOR POSIX FILE SYSTEM SEMANTICS";
            source = "PLEASE CONTACT DISC PUBLISHER FOR SPECIFICATION SOURCE.  SEE PUBLISHER IDENTIFIER IN PRIMARY VOLUME DESCRIPTOR FOR CONTACT INFORMATION";
        } else {
            id = "IEEE 1282";
            descriptor = "THE IEEE 1282 PROTOCOL PROVIDES SUPPORT FOR POSIX FILE SYSTEM SEMANTICS.";
            source = "PLEASE CONTACT THE IEEE STANDARDS DEPARTMENT, PISCATAWAY, NJ, USA FOR THE 1282 SPECIFICATION.";
        }
        ByteArrayDataReference idRef = new ByteArrayDataReference(id.getBytes());
        ByteArrayDataReference descriptorRef = new ByteArrayDataReference(descriptor.getBytes());
        ByteArrayDataReference sourceRef = new ByteArrayDataReference(source.getBytes());
        this.doEREntry(idRef, descriptorRef, sourceRef, 1);
    }

    public void doRREntry(int flags) throws HandlerException {
        if (MKISOFS_COMPATIBILITY) {
            if (flags < 0 || flags > 255) {
                throw new HandlerException("Invalid RR flags: " + flags);
            }
            this.streamHandler.startElement(new SystemUseEntryElement("RR", 1));
            this.streamHandler.data(new ByteDataReference(flags));
            this.streamHandler.endElement();
        }
    }
}

