/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.sabre.impl;

import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.FixupListener;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FileFixup
implements Fixup {
    private RandomAccessFile randomAccessFile = null;
    private long position = 0L;
    private long available = 0L;
    private boolean closed = false;

    public FileFixup(RandomAccessFile file, long position, long available) {
        this.randomAccessFile = file;
        this.position = position;
        this.available = available;
    }

    @Override
    public void data(DataReference reference) throws HandlerException {
        InputStream inputStream = null;
        byte[] buffer = null;
        int bytesRead = 0;
        if (!this.closed) {
            if (reference.getLength() > this.available) {
                throw new HandlerException("Fixup larger than available space.");
            }
            try {
                this.randomAccessFile.seek(this.position);
                buffer = new byte[1024];
                inputStream = reference.createInputStream();
                while ((bytesRead = inputStream.read(buffer, 0, 1024)) != -1) {
                    this.randomAccessFile.write(buffer, 0, bytesRead);
                }
                this.position += reference.getLength();
                this.available -= reference.getLength();
            }
            catch (FileNotFoundException e2) {
                throw new HandlerException(e2);
            }
            catch (IOException e3) {
                throw new HandlerException(e3);
            }
        }
    }

    @Override
    public Fixup fixup(DataReference reference) throws HandlerException {
        throw new RuntimeException("Cannot yet handle fixup in fixup.");
    }

    @Override
    public long mark() throws HandlerException {
        return this.position;
    }

    @Override
    public void close() throws HandlerException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void addFixupListener(FixupListener listener) throws HandlerException {
    }

    public void removeFixupListener(FixupListener listener) throws HandlerException {
    }

    public RandomAccessFile getFile() {
        return this.randomAccessFile;
    }

    public long getPosition() {
        return this.position;
    }

    public long getAvailable() {
        return this.available;
    }
}

