/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.udflib;

import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.udflib.SabreUDFElementFactory;
import com.github.stephenc.javaisotools.udflib.UDFImageBuilderFile;
import com.github.stephenc.javaisotools.udflib.UDFLayoutInformation;
import com.github.stephenc.javaisotools.udflib.UDFRevision;
import com.github.stephenc.javaisotools.udflib.handler.DescriptorTagHandler;
import com.github.stephenc.javaisotools.udflib.handler.PaddingHandler;
import com.github.stephenc.javaisotools.udflib.handler.SerializationHandler;
import com.github.stephenc.javaisotools.udflib.handler.UDF102Handler;
import com.github.stephenc.javaisotools.udflib.handler.UDF201Handler;
import com.github.stephenc.javaisotools.udflib.handler.UDF260Handler;
import java.io.File;
import java.util.Calendar;

public class SabreUDFImageBuilder {
    private String imageIdentifier = "SabreUDFImageBuilder Disc";
    private String applicationIdentifier = "*SabreUDFImageBuilder";
    private byte[] applicationIdentifierSuffix = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
    private int blockSize = 2048;
    private UDFImageBuilderFile rootUDFImageBuilderFile = new UDFImageBuilderFile("");

    public void setImageIdentifier(String imageIdentifier) throws Exception {
        if (imageIdentifier.length() > 30) {
            throw new Exception("error: image identifier length > 30 characters");
        }
        this.imageIdentifier = imageIdentifier;
    }

    public void addFileToRootDirectory(UDFImageBuilderFile myUDFImageBuilderFile) throws Exception {
        this.rootUDFImageBuilderFile.addChild(myUDFImageBuilderFile);
    }

    public void addFileToRootDirectory(File myFile) throws Exception {
        this.rootUDFImageBuilderFile.addChild(myFile);
    }

    private StreamHandler buildStreamHandlerPipeline(UDFRevision myUDFRevision, String outputFilename) throws HandlerException {
        StreamHandler myStreamHandler = new SerializationHandler(new File(outputFilename));
        myStreamHandler = new PaddingHandler(myStreamHandler, myStreamHandler);
        myStreamHandler = new DescriptorTagHandler(myStreamHandler, myStreamHandler);
        if (myUDFRevision == UDFRevision.Revision102) {
            myStreamHandler = new UDF102Handler(myStreamHandler, myStreamHandler);
        } else if (myUDFRevision == UDFRevision.Revision201) {
            myStreamHandler = new UDF201Handler(myStreamHandler, myStreamHandler);
        } else if (myUDFRevision == UDFRevision.Revision260) {
            myStreamHandler = new UDF260Handler(myStreamHandler, myStreamHandler);
        }
        return myStreamHandler;
    }

    public void writeImage(String outputFilename, UDFRevision myUDFRevision) throws HandlerException {
        long recordingTimeMillis = Calendar.getInstance().getTimeInMillis();
        UDFLayoutInformation myUDFLayoutInformation = null;
        try {
            myUDFLayoutInformation = new UDFLayoutInformation(this.rootUDFImageBuilderFile, myUDFRevision, this.blockSize);
        }
        catch (Exception ex) {
            throw new HandlerException(ex);
        }
        StreamHandler myStreamHandler = this.buildStreamHandlerPipeline(myUDFRevision, outputFilename);
        SabreUDFElementFactory mySabreUDFElementFactory = new SabreUDFElementFactory(myStreamHandler);
        mySabreUDFElementFactory.startUDFImage();
        mySabreUDFElementFactory.startReservedArea();
        mySabreUDFElementFactory.endReservedArea();
        mySabreUDFElementFactory.startVRS();
        mySabreUDFElementFactory.endVRS();
        mySabreUDFElementFactory.startEmptyArea();
        mySabreUDFElementFactory.doEmptyArea(237 * this.blockSize);
        mySabreUDFElementFactory.endEmptyArea();
        mySabreUDFElementFactory.startAVDP();
        mySabreUDFElementFactory.doAVDP(myUDFLayoutInformation.AVDP1Block, myUDFLayoutInformation.MVDSStartingBlock, myUDFLayoutInformation.RVDSStartingBlock);
        mySabreUDFElementFactory.endAVDP();
        mySabreUDFElementFactory.startPVD();
        mySabreUDFElementFactory.doPVD(myUDFLayoutInformation.PVD1Block, 1L, recordingTimeMillis, this.imageIdentifier, this.applicationIdentifier, this.applicationIdentifierSuffix);
        mySabreUDFElementFactory.endPVD();
        mySabreUDFElementFactory.startPD();
        mySabreUDFElementFactory.doPD(myUDFLayoutInformation.PD1Block, 2L, myUDFLayoutInformation.physicalPartitionStartingBlock, myUDFLayoutInformation.physicalPartitionEndingBlock, this.applicationIdentifier, this.applicationIdentifierSuffix);
        mySabreUDFElementFactory.endPD();
        mySabreUDFElementFactory.startLVD();
        mySabreUDFElementFactory.doLVD(myUDFLayoutInformation.LVD1Block, 3L, myUDFLayoutInformation.LVIDSStartingBlock, myUDFLayoutInformation.LVIDSEndingBlock, myUDFLayoutInformation.metadataAllocationUnitSize, myUDFLayoutInformation.metadataAlignmentUnitSize, myUDFLayoutInformation.mainMetadataFileLocation, myUDFLayoutInformation.mirrorMetadataFileLocation, myUDFLayoutInformation.partitionToStoreMetadataOn, myUDFLayoutInformation.FSDLocation, this.applicationIdentifier, this.applicationIdentifierSuffix, this.imageIdentifier);
        mySabreUDFElementFactory.endLVD();
        mySabreUDFElementFactory.startUSD();
        mySabreUDFElementFactory.doUSD(myUDFLayoutInformation.USD1Block, 4L, 19L, 256L);
        mySabreUDFElementFactory.endUSD();
        mySabreUDFElementFactory.startIUVD();
        mySabreUDFElementFactory.doIUVD(myUDFLayoutInformation.IUVD1Block, 5L, this.applicationIdentifier, this.applicationIdentifierSuffix, this.imageIdentifier);
        mySabreUDFElementFactory.endIUVD();
        mySabreUDFElementFactory.startTD();
        mySabreUDFElementFactory.doTD(myUDFLayoutInformation.TD1Block);
        mySabreUDFElementFactory.endTD();
        mySabreUDFElementFactory.startEmptyArea();
        mySabreUDFElementFactory.doEmptyArea((int)(myUDFLayoutInformation.MVDSEndingBlock - myUDFLayoutInformation.MVDSStartingBlock - 6L) * this.blockSize);
        mySabreUDFElementFactory.endEmptyArea();
        mySabreUDFElementFactory.startLVID();
        mySabreUDFElementFactory.doLVID(myUDFLayoutInformation.LVIDSStartingBlock + 0L, recordingTimeMillis, myUDFLayoutInformation.fileCount, myUDFLayoutInformation.directoryCount, this.applicationIdentifier, this.applicationIdentifierSuffix, myUDFLayoutInformation.sizeTable, myUDFLayoutInformation.freespaceTable, myUDFLayoutInformation.nextUniqueId);
        mySabreUDFElementFactory.endLVID();
        mySabreUDFElementFactory.startTD();
        mySabreUDFElementFactory.doTD(myUDFLayoutInformation.LVIDSStartingBlock + 1L);
        mySabreUDFElementFactory.endTD();
        mySabreUDFElementFactory.startEmptyArea();
        mySabreUDFElementFactory.doEmptyArea((int)(myUDFLayoutInformation.LVIDSEndingBlock - myUDFLayoutInformation.LVIDSStartingBlock - 2L) * this.blockSize);
        mySabreUDFElementFactory.endEmptyArea();
        mySabreUDFElementFactory.startEmptyArea();
        mySabreUDFElementFactory.doEmptyArea(this.blockSize);
        mySabreUDFElementFactory.endEmptyArea();
        mySabreUDFElementFactory.startMetadataFile();
        mySabreUDFElementFactory.doMetadataFile(recordingTimeMillis, this.applicationIdentifier, this.applicationIdentifierSuffix, myUDFLayoutInformation, myUDFLayoutInformation.mainMetadataFileLocation, (byte)-6);
        mySabreUDFElementFactory.endMetadataFile();
        mySabreUDFElementFactory.startFSD();
        mySabreUDFElementFactory.doFSD(myUDFLayoutInformation.FSDLocation, recordingTimeMillis, myUDFLayoutInformation.rootFELocation, myUDFLayoutInformation.partitionToStoreMetadataOn, this.imageIdentifier);
        mySabreUDFElementFactory.endFSD();
        for (UDFImageBuilderFile myUDFImageBuilderFile : myUDFLayoutInformation.linearUDFImageBuilderFileOrdering) {
            mySabreUDFElementFactory.startFE();
            mySabreUDFElementFactory.doFE(myUDFImageBuilderFile, myUDFLayoutInformation, this.applicationIdentifier, this.applicationIdentifierSuffix);
            mySabreUDFElementFactory.endFE();
        }
        mySabreUDFElementFactory.startEmptyArea();
        mySabreUDFElementFactory.doEmptyArea((int)(myUDFLayoutInformation.metadataEmptyArea * (long)this.blockSize));
        mySabreUDFElementFactory.endEmptyArea();
        for (UDFImageBuilderFile myUDFImageBuilderFile : myUDFLayoutInformation.linearUDFImageBuilderFileOrdering) {
            UDFLayoutInformation.FileEntryPosition myFileEntryPosition = myUDFLayoutInformation.fileEntryPositions.get(myUDFImageBuilderFile);
            if (myUDFImageBuilderFile.getFileType() != UDFImageBuilderFile.FileType.File || myFileEntryPosition.dataBlock == -1L) continue;
            mySabreUDFElementFactory.startRawFileData();
            mySabreUDFElementFactory.doRawFileData(myUDFImageBuilderFile.getSourceFile());
            mySabreUDFElementFactory.endRawFileData();
        }
        mySabreUDFElementFactory.startMetadataFile();
        mySabreUDFElementFactory.doMetadataFile(recordingTimeMillis, this.applicationIdentifier, this.applicationIdentifierSuffix, myUDFLayoutInformation, myUDFLayoutInformation.mirrorMetadataFileLocation, (byte)-5);
        mySabreUDFElementFactory.endMetadataFile();
        mySabreUDFElementFactory.startPVD();
        mySabreUDFElementFactory.doPVD(myUDFLayoutInformation.PVD2Block, 1L, recordingTimeMillis, this.imageIdentifier, this.applicationIdentifier, this.applicationIdentifierSuffix);
        mySabreUDFElementFactory.endPVD();
        mySabreUDFElementFactory.startPD();
        mySabreUDFElementFactory.doPD(myUDFLayoutInformation.PD2Block, 2L, myUDFLayoutInformation.physicalPartitionStartingBlock, myUDFLayoutInformation.physicalPartitionEndingBlock, this.applicationIdentifier, this.applicationIdentifierSuffix);
        mySabreUDFElementFactory.endPD();
        mySabreUDFElementFactory.startLVD();
        mySabreUDFElementFactory.doLVD(myUDFLayoutInformation.LVD2Block, 3L, myUDFLayoutInformation.LVIDSStartingBlock, myUDFLayoutInformation.LVIDSEndingBlock, myUDFLayoutInformation.metadataAllocationUnitSize, myUDFLayoutInformation.metadataAlignmentUnitSize, myUDFLayoutInformation.mainMetadataFileLocation, myUDFLayoutInformation.mirrorMetadataFileLocation, myUDFLayoutInformation.partitionToStoreMetadataOn, myUDFLayoutInformation.FSDLocation, this.applicationIdentifier, this.applicationIdentifierSuffix, this.imageIdentifier);
        mySabreUDFElementFactory.endLVD();
        mySabreUDFElementFactory.startUSD();
        mySabreUDFElementFactory.doUSD(myUDFLayoutInformation.USD2Block, 4L, 19L, 256L);
        mySabreUDFElementFactory.endUSD();
        mySabreUDFElementFactory.startIUVD();
        mySabreUDFElementFactory.doIUVD(myUDFLayoutInformation.IUVD2Block, 5L, this.applicationIdentifier, this.applicationIdentifierSuffix, this.imageIdentifier);
        mySabreUDFElementFactory.endIUVD();
        mySabreUDFElementFactory.startTD();
        mySabreUDFElementFactory.doTD(myUDFLayoutInformation.TD2Block);
        mySabreUDFElementFactory.endTD();
        mySabreUDFElementFactory.startEmptyArea();
        mySabreUDFElementFactory.doEmptyArea((int)(myUDFLayoutInformation.RVDSEndingBlock - myUDFLayoutInformation.RVDSStartingBlock - 5L) * this.blockSize);
        mySabreUDFElementFactory.endEmptyArea();
        mySabreUDFElementFactory.startAVDP();
        mySabreUDFElementFactory.doAVDP(myUDFLayoutInformation.AVDP2Block, myUDFLayoutInformation.MVDSStartingBlock, myUDFLayoutInformation.RVDSStartingBlock);
        mySabreUDFElementFactory.endAVDP();
        mySabreUDFElementFactory.endUDFImage();
    }
}

