/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy.iso9660;

import java.io.IOException;
import net.didion.loopy.FileEntry;
import net.didion.loopy.LoopyException;
import net.didion.loopy.VolumeDescriptorSet;
import net.didion.loopy.iso9660.ISO9660FileEntry;
import net.didion.loopy.iso9660.ISO9660FileSystem;
import net.didion.loopy.iso9660.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ISO9660VolumeDescriptorSet
implements VolumeDescriptorSet {
    public static final int TYPE_BOOTRECORD = 0;
    public static final int TYPE_PRIMARY_DESCRIPTOR = 1;
    public static final int TYPE_SUPPLEMENTARY_DESCRIPTOR = 2;
    public static final int TYPE_PARTITION_DESCRIPTOR = 3;
    public static final int TYPE_TERMINATOR = 255;
    private static final Log log = LogFactory.getLog(ISO9660VolumeDescriptorSet.class);
    private final ISO9660FileSystem isoFile;
    private String systemIdentifier;
    private String volumeSetIdentifier;
    private String volumeIdentifier;
    private String publisher;
    private String preparer;
    private String application;
    private ISO9660FileEntry rootDirectoryEntry;
    private String standardIdentifier;
    private long totalBlocks;
    private int volumeSetSize;
    private int volumeSequenceNumber;
    private long creationTime;
    private long mostRecentModificationTime;
    private long expirationTime;
    private long effectiveTime;
    private long pathTableSize;
    private long locationOfLittleEndianPathTable;
    private long locationOfOptionalLittleEndianPathTable;
    private long locationOfBigEndianPathTable;
    private long locationOfOptionalBigEndianPathTable;
    public String encoding = "US-ASCII";
    public String escapeSequences;
    private boolean hasPrimary = false;
    private boolean hasSupplementary = false;

    public ISO9660VolumeDescriptorSet(ISO9660FileSystem fileSystem) {
        this.isoFile = fileSystem;
    }

    public boolean deserialize(byte[] descriptor) throws IOException {
        int type = Util.getUInt8(descriptor, 1);
        boolean terminator = false;
        switch (type) {
            case 255: {
                if (!this.hasPrimary) {
                    throw new LoopyException("No primary volume descriptor found");
                }
                terminator = true;
                break;
            }
            case 0: {
                log.debug("Found boot record");
                break;
            }
            case 1: {
                log.debug("Found primary descriptor");
                this.deserializePrimary(descriptor);
                break;
            }
            case 2: {
                log.debug("Found supplementatory descriptor");
                this.deserializeSupplementary(descriptor);
                break;
            }
            case 3: {
                log.debug("Found partition descriptor");
                break;
            }
            default: {
                log.debug("Found unknown descriptor with type " + type);
            }
        }
        return terminator;
    }

    private void deserializePrimary(byte[] descriptor) throws IOException {
        if (this.hasPrimary) {
            return;
        }
        this.validateBlockSize(descriptor);
        if (!this.hasSupplementary) {
            this.deserializeCommon(descriptor);
        }
        this.standardIdentifier = Util.getDChars(descriptor, 2, 5);
        this.volumeSetSize = Util.getUInt16Both(descriptor, 121);
        this.volumeSequenceNumber = Util.getUInt16Both(descriptor, 125);
        this.totalBlocks = Util.getUInt32Both(descriptor, 81);
        this.publisher = Util.getDChars(descriptor, 319, 128);
        this.preparer = Util.getDChars(descriptor, 447, 128);
        this.application = Util.getDChars(descriptor, 575, 128);
        this.creationTime = Util.getStringDate(descriptor, 814);
        this.mostRecentModificationTime = Util.getStringDate(descriptor, 831);
        this.expirationTime = Util.getStringDate(descriptor, 848);
        this.effectiveTime = Util.getStringDate(descriptor, 865);
        this.pathTableSize = Util.getUInt32Both(descriptor, 133);
        this.locationOfLittleEndianPathTable = Util.getUInt32LE(descriptor, 141);
        this.locationOfOptionalLittleEndianPathTable = Util.getUInt32LE(descriptor, 145);
        this.locationOfBigEndianPathTable = Util.getUInt32BE(descriptor, 149);
        this.locationOfOptionalBigEndianPathTable = Util.getUInt32BE(descriptor, 153);
        this.hasPrimary = true;
    }

    private void deserializeSupplementary(byte[] descriptor) throws IOException {
        if (this.hasSupplementary) {
            return;
        }
        this.validateBlockSize(descriptor);
        String escapeSequences = Util.getDChars(descriptor, 89, 32);
        String enc = this.getEncoding(escapeSequences);
        if (null != enc) {
            this.encoding = enc;
            this.escapeSequences = escapeSequences;
            this.deserializeCommon(descriptor);
            this.hasSupplementary = true;
        } else {
            log.warn("Unsupported encoding, escapeSequences: '" + this.escapeSequences + "'");
        }
    }

    private void deserializeCommon(byte[] descriptor) throws IOException {
        this.systemIdentifier = Util.getAChars(descriptor, 9, 32, this.encoding);
        this.volumeIdentifier = Util.getDChars(descriptor, 41, 32, this.encoding);
        this.volumeSetIdentifier = Util.getDChars(descriptor, 191, 128, this.encoding);
        this.rootDirectoryEntry = new ISO9660FileEntry(this.isoFile, descriptor, 157);
    }

    private void validateBlockSize(byte[] descriptor) throws IOException {
        int blockSize = Util.getUInt16Both(descriptor, 129);
        if (blockSize != 2048) {
            throw new LoopyException("Invalid block size: " + blockSize);
        }
    }

    private String getEncoding(String escapeSequences) {
        String encoding = null;
        if (escapeSequences.equals("%/@")) {
            encoding = "UTF-16BE";
        } else if (escapeSequences.equals("%/C")) {
            encoding = "UTF-16BE";
        } else if (escapeSequences.equals("%/E")) {
            encoding = "UTF-16BE";
        }
        return encoding;
    }

    public boolean hasSupplementary() {
        return this.hasSupplementary;
    }

    public String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public String getVolumeSetIdentifier() {
        return this.volumeSetIdentifier;
    }

    public String getVolumeIdentifier() {
        return this.volumeIdentifier;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getPreparer() {
        return this.preparer;
    }

    public String getApplication() {
        return this.application;
    }

    public FileEntry getRootEntry() {
        return this.rootDirectoryEntry;
    }

    public String getStandardIdentifier() {
        return this.standardIdentifier;
    }

    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    public int getVolumeSetSize() {
        return this.volumeSetSize;
    }

    public int getVolumeSequenceNumber() {
        return this.volumeSequenceNumber;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastModifiedTime() {
        return this.mostRecentModificationTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getEffectiveTime() {
        return this.effectiveTime;
    }

    public long getPathTableSize() {
        return this.pathTableSize;
    }

    public long getLocationOfLittleEndianPathTable() {
        return this.locationOfLittleEndianPathTable;
    }

    public long getLocationOfOptionalLittleEndianPathTable() {
        return this.locationOfOptionalLittleEndianPathTable;
    }

    public long getLocationOfBigEndianPathTable() {
        return this.locationOfBigEndianPathTable;
    }

    public long getLocationOfOptionalBigEndianPathTable() {
        return this.locationOfOptionalBigEndianPathTable;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEscapeSequences() {
        return this.escapeSequences;
    }
}

