/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.cache;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystem;

class FileSystemAndNameKey
implements Comparable {
    private final FileSystem fileSystem;
    private final FileName fileName;
    private final int fileSystemId;

    FileSystemAndNameKey(FileSystem fileSystem, FileName fileName) {
        this.fileSystem = fileSystem;
        this.fileSystemId = System.identityHashCode(fileSystem);
        this.fileName = fileName;
    }

    public int compareTo(Object o2) {
        FileSystemAndNameKey other = (FileSystemAndNameKey)o2;
        if (this.fileSystemId < other.fileSystemId) {
            return -1;
        }
        if (this.fileSystemId > other.fileSystemId) {
            return 1;
        }
        return this.fileName.compareTo(other.fileName);
    }

    FileSystem getFileSystem() {
        return this.fileSystem;
    }

    FileName getFileName() {
        return this.fileName;
    }
}

