/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.AbstractVfsContainer;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.FileSystemKey;
import org.apache.commons.vfs.provider.local.GenericFileNameParser;

public abstract class AbstractFileProvider
extends AbstractVfsContainer
implements FileProvider {
    private FileNameParser parser;
    private final Map fileSystems = new TreeMap();

    public AbstractFileProvider() {
        this.parser = GenericFileNameParser.getInstance();
    }

    protected FileNameParser getFileNameParser() {
        return this.parser;
    }

    protected void setFileNameParser(FileNameParser parser) {
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            this.fileSystems.clear();
        }
        super.close();
    }

    public FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions properties) throws FileSystemException {
        throw new FileSystemException("vfs.provider/not-layered-fs.error", scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileSystem(Comparable key, FileSystem fs) throws FileSystemException {
        this.addComponent(fs);
        FileSystemKey treeKey = new FileSystemKey(key, fs.getFileSystemOptions());
        ((AbstractFileSystem)fs).setCacheKey(treeKey);
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            this.fileSystems.put(treeKey, fs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem findFileSystem(Comparable key, FileSystemOptions fileSystemProps) {
        FileSystemKey treeKey = new FileSystemKey(key, fileSystemProps);
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            return (FileSystem)this.fileSystems.get(treeKey);
        }
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUnusedResources() {
        Object[] item;
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            item = this.fileSystems.values().toArray();
        }
        for (int i2 = 0; i2 < item.length; ++i2) {
            AbstractFileSystem fs = (AbstractFileSystem)item[i2];
            if (!fs.isReleaseable()) continue;
            fs.closeCommunicationLink();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileSystem(FileSystem filesystem) {
        AbstractFileSystem fs = (AbstractFileSystem)filesystem;
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            if (fs.getCacheKey() != null) {
                this.fileSystems.remove(fs.getCacheKey());
            }
        }
        this.removeComponent(fs);
        fs.close();
    }

    public FileName parseUri(FileName base, String uri) throws FileSystemException {
        if (this.getFileNameParser() != null) {
            return this.getFileNameParser().parseUri(this.getContext(), base, uri);
        }
        throw new FileSystemException("vfs.provider/filename-parser-missing.error");
    }
}

