/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ram;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.ram.RamFileObject;
import org.apache.commons.vfs.util.RandomAccessMode;

public class RamFileRandomAccessContent
implements RandomAccessContent {
    byte[] buf;
    protected int filePointer = 0;
    private byte[] buffer8 = new byte[8];
    private byte[] buffer4 = new byte[4];
    private byte[] buffer2 = new byte[2];
    private byte[] buffer1 = new byte[1];
    private RandomAccessMode mode;
    private RamFileObject file;
    private InputStream rafis;

    public RamFileRandomAccessContent(RamFileObject file, RandomAccessMode mode) {
        this.buf = file.getData().getBuffer();
        this.file = file;
        this.mode = mode;
        this.rafis = new InputStream(){

            public int read() throws IOException {
                try {
                    return RamFileRandomAccessContent.this.readByte();
                }
                catch (EOFException e2) {
                    return -1;
                }
            }

            public long skip(long n2) throws IOException {
                RamFileRandomAccessContent.this.seek(RamFileRandomAccessContent.this.getFilePointer() + n2);
                return n2;
            }

            public void close() throws IOException {
                this.close();
            }

            public int read(byte[] b2) throws IOException {
                return this.read(b2);
            }

            public int read(byte[] b2, int off, int len) throws IOException {
                int retLen = Math.min(len, RamFileRandomAccessContent.this.getLeftBytes());
                RamFileRandomAccessContent.this.readFully(b2, off, retLen);
                return retLen;
            }

            public int available() throws IOException {
                return RamFileRandomAccessContent.this.getLeftBytes();
            }
        };
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long pos) throws IOException {
        this.filePointer = (int)pos;
    }

    public long length() throws IOException {
        return this.buf.length;
    }

    public void close() throws IOException {
    }

    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    public char readChar() throws IOException {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public int readInt() throws IOException {
        return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    public int readUnsignedByte() throws IOException {
        if (this.filePointer < this.buf.length) {
            return this.buf[this.filePointer++] & 0xFF;
        }
        throw new EOFException();
    }

    public int readUnsignedShort() throws IOException {
        this.readFully(this.buffer2);
        return RamFileRandomAccessContent.toUnsignedShort(this.buffer2);
    }

    public long readLong() throws IOException {
        this.readFully(this.buffer8);
        return RamFileRandomAccessContent.toLong(this.buffer8);
    }

    public short readShort() throws IOException {
        this.readFully(this.buffer2);
        return RamFileRandomAccessContent.toShort(this.buffer2);
    }

    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    public int skipBytes(int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("The skip number can't be negative");
        }
        long newPos = this.filePointer + n2;
        if (newPos > (long)this.buf.length) {
            throw new IndexOutOfBoundsException("Tyring to skip too much bytes");
        }
        this.seek(newPos);
        return n2;
    }

    public void readFully(byte[] b2) throws IOException {
        this.readFully(b2, 0, b2.length);
    }

    public void readFully(byte[] b2, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Length is lower than 0");
        }
        if (len > this.getLeftBytes()) {
            throw new IndexOutOfBoundsException("Read length (" + len + ") is higher than buffer left bytes (" + this.getLeftBytes() + ") ");
        }
        System.arraycopy(this.buf, this.filePointer, b2, off, len);
        this.filePointer += len;
    }

    private int getLeftBytes() {
        return this.buf.length - this.filePointer;
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.getLeftBytes() < len) {
            int newSize = this.buf.length + len - this.getLeftBytes();
            this.file.resize(newSize);
            this.buf = this.file.getData().getBuffer();
        }
        System.arraycopy(b2, off, this.buf, this.filePointer, len);
        this.filePointer += len;
    }

    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public void writeByte(int i2) throws IOException {
        this.write(i2);
    }

    public static long toLong(byte[] b2) {
        return ((long)b2[7] & 0xFFL) + (((long)b2[6] & 0xFFL) << 8) + (((long)b2[5] & 0xFFL) << 16) + (((long)b2[4] & 0xFFL) << 24) + (((long)b2[3] & 0xFFL) << 32) + (((long)b2[2] & 0xFFL) << 40) + (((long)b2[1] & 0xFFL) << 48) + (((long)b2[0] & 0xFFL) << 56);
    }

    public static byte[] toBytes(long n2, byte[] b2) {
        b2[7] = (byte)n2;
        b2[6] = (byte)(n2 >>>= 8);
        b2[5] = (byte)(n2 >>>= 8);
        b2[4] = (byte)(n2 >>>= 8);
        b2[3] = (byte)(n2 >>>= 8);
        b2[2] = (byte)(n2 >>>= 8);
        b2[1] = (byte)(n2 >>>= 8);
        b2[0] = (byte)(n2 >>>= 8);
        return b2;
    }

    public static short toShort(byte[] b2) {
        return (short)RamFileRandomAccessContent.toUnsignedShort(b2);
    }

    public static int toUnsignedShort(byte[] b2) {
        return (b2[1] & 0xFF) + ((b2[0] & 0xFF) << 8);
    }

    public void write(int b2) throws IOException {
        this.buffer1[0] = (byte)b2;
        this.write(this.buffer1);
    }

    public void writeBoolean(boolean v2) throws IOException {
        this.write(v2 ? 1 : 0);
    }

    public void writeBytes(String s2) throws IOException {
        this.write(s2.getBytes());
    }

    public void writeChar(int v2) throws IOException {
        this.buffer2[0] = (byte)(v2 >>> 8 & 0xFF);
        this.buffer2[1] = (byte)(v2 >>> 0 & 0xFF);
        this.write(this.buffer2);
    }

    public void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeChar(s2.charAt(i2));
        }
    }

    public void writeDouble(double v2) throws IOException {
        this.writeLong(Double.doubleToLongBits(v2));
    }

    public void writeFloat(float v2) throws IOException {
        this.writeInt(Float.floatToIntBits(v2));
    }

    public void writeInt(int v2) throws IOException {
        this.buffer4[0] = (byte)(v2 >>> 24 & 0xFF);
        this.buffer4[1] = (byte)(v2 >>> 16 & 0xFF);
        this.buffer4[2] = (byte)(v2 >>> 8 & 0xFF);
        this.buffer4[3] = (byte)(v2 & 0xFF);
        this.write(this.buffer4);
    }

    public void writeLong(long v2) throws IOException {
        this.write(RamFileRandomAccessContent.toBytes(v2, this.buffer8));
    }

    public void writeShort(int v2) throws IOException {
        this.buffer2[0] = (byte)(v2 >>> 8 & 0xFF);
        this.buffer2[1] = (byte)(v2 & 0xFF);
        this.write(this.buffer2);
    }

    public void writeUTF(String str) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(str.length());
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeUTF(str);
        dataOut.flush();
        dataOut.close();
        byte[] b2 = out.toByteArray();
        this.write(b2);
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("deprecated");
    }

    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }
}

