/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.util.prefs.Preferences;
import org.jdesktop.swingx.auth.UserNameStore;

public class DefaultUserNameStore
extends UserNameStore {
    private static final String USER_KEY = "usernames";
    private static final String NUM_KEY = "usernames.length";
    private Preferences prefs;
    private String[] userNames = new String[0];

    public void loadUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            int n2 = this.prefs.getInt(NUM_KEY, 0);
            String[] names = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                names[i2] = this.prefs.get("usernames." + i2, null);
            }
            this.setUserNames(names);
        }
    }

    public void saveUserNames() {
        this.initPrefs();
        if (this.prefs != null) {
            this.prefs.putInt(NUM_KEY, this.userNames.length);
            for (int i2 = 0; i2 < this.userNames.length; ++i2) {
                this.prefs.put("usernames." + i2, this.userNames[i2]);
            }
        }
    }

    public String[] getUserNames() {
        String[] copy = new String[this.userNames.length];
        System.arraycopy(this.userNames, 0, copy, 0, this.userNames.length);
        return copy;
    }

    public void setUserNames(String[] userNames) {
        userNames = userNames == null ? new String[]{} : userNames;
        String[] old = this.getUserNames();
        this.userNames = userNames;
        this.firePropertyChange("userNames", old, this.getUserNames());
    }

    public void addUserName(String name) {
        if (!this.containsUserName(name)) {
            String[] newNames = new String[this.userNames.length + 1];
            for (int i2 = 0; i2 < this.userNames.length; ++i2) {
                newNames[i2] = this.userNames[i2];
            }
            newNames[newNames.length - 1] = name;
            this.setUserNames(newNames);
        }
    }

    public void removeUserName(String name) {
        if (this.containsUserName(name)) {
            String[] newNames = new String[this.userNames.length - 1];
            int index = 0;
            for (String s2 : this.userNames) {
                if (s2.equals(name)) continue;
                newNames[index++] = s2;
            }
            this.setUserNames(newNames);
        }
    }

    public boolean containsUserName(String name) {
        for (String s2 : this.userNames) {
            if (!s2.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void setPreferences(Preferences prefs) {
        Preferences old = this.getPreferences();
        this.initPrefs();
        this.prefs = prefs;
        this.firePropertyChange("preferences", old, this.getPreferences());
        if (this.prefs != old) {
            this.loadUserNames();
        }
    }

    private void initPrefs() {
        if (this.prefs == null) {
            this.prefs = Preferences.userNodeForPackage(DefaultUserNameStore.class);
            this.prefs = this.prefs.node("DefaultUserNameStore");
        }
    }
}

