/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jdesktop.swingx.auth.LoginService;

public class JAASLoginService
extends LoginService {
    private static final Logger LOG = Logger.getLogger(JAASLoginService.class.getName());
    protected LoginContext loginContext;

    public JAASLoginService(String server) {
        super(server);
    }

    public JAASLoginService() {
    }

    public boolean authenticate(String name, char[] password, String server) throws Exception {
        if (server != null && !server.equals(this.getServer())) {
            this.setServer(server);
        }
        this.loginContext = null;
        try {
            this.loginContext = new LoginContext(this.getServer(), new JAASCallbackHandler(name, password));
            this.loginContext.login();
            return true;
        }
        catch (AccountExpiredException e2) {
            LOG.log(Level.WARNING, "", e2);
            return false;
        }
        catch (CredentialExpiredException e3) {
            LOG.log(Level.WARNING, "", e3);
            return false;
        }
        catch (FailedLoginException e4) {
            LOG.log(Level.WARNING, "", e4);
            return false;
        }
        catch (LoginException e5) {
            LOG.log(Level.WARNING, "", e5);
            return false;
        }
        catch (Throwable e6) {
            LOG.log(Level.WARNING, "", e6);
            return false;
        }
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public Subject getSubject() {
        if (this.loginContext == null) {
            return null;
        }
        return this.loginContext.getSubject();
    }

    class JAASCallbackHandler
    implements CallbackHandler {
        private String name;
        private char[] password;

        public JAASCallbackHandler(String name, char[] passwd) {
            this.name = name;
            this.password = passwd;
        }

        public void handle(Callback[] callbacks) throws IOException {
            for (int i2 = 0; i2 < callbacks.length; ++i2) {
                Callback cb;
                if (callbacks[i2] instanceof NameCallback) {
                    cb = (NameCallback)callbacks[i2];
                    ((NameCallback)cb).setName(this.name);
                    continue;
                }
                if (!(callbacks[i2] instanceof PasswordCallback)) continue;
                cb = (PasswordCallback)callbacks[i2];
                ((PasswordCallback)cb).setPassword(this.password);
            }
        }
    }
}

