/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.sabre.DataReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;

public class ISO9660ShortDateDataReference
implements DataReference {
    private Date date = null;

    public ISO9660ShortDateDataReference(Date date) {
        this.date = date;
    }

    public ISO9660ShortDateDataReference(long date) {
        this(new Date(date));
    }

    public ISO9660ShortDateDataReference() {
        this(new Date());
    }

    @Override
    public long getLength() {
        return 7L;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        byte[] buffer = this.date == null ? this.getEmptyDate() : this.getDate();
        return new ByteArrayInputStream(buffer);
    }

    private byte[] getEmptyDate() {
        byte[] buffer = new byte[]{0, 0, 0, 0, 0, 0, 0};
        return buffer;
    }

    private byte[] getDate() {
        byte[] buffer = new byte[7];
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date);
        int year = cal.get(1) - 1900;
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int gmt_offset = cal.get(15) / 900000;
        buffer[0] = (byte)year;
        buffer[1] = (byte)month;
        buffer[2] = (byte)day;
        buffer[3] = (byte)hour;
        buffer[4] = (byte)minute;
        buffer[5] = (byte)second;
        buffer[6] = (byte)gmt_offset;
        return buffer;
    }
}

