/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Element;
import com.github.stephenc.javaisotools.iso9660.impl.LogicalSectorElement;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.EmptyByteArrayDataReference;
import com.github.stephenc.javaisotools.sabre.ContentHandler;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StructureHandler;
import com.github.stephenc.javaisotools.sabre.impl.ChainingStreamHandler;
import java.util.Stack;

public class LogicalSectorPaddingHandler
extends ChainingStreamHandler {
    private long bytesWritten = 0L;
    private Stack elements = new Stack();
    private boolean padEnd;

    public LogicalSectorPaddingHandler(StructureHandler chainingStructureHandler, ContentHandler chainingContentHandler) {
        super(chainingStructureHandler, chainingContentHandler);
    }

    public void setPadEnd(boolean padEnd) {
        this.padEnd = padEnd;
    }

    @Override
    public void startElement(Element element) throws HandlerException {
        if (element instanceof LogicalSectorElement || this.isSAElement(element)) {
            this.bytesWritten = 0L;
        }
        this.elements.push(element);
        super.startElement(element);
    }

    private boolean isSAElement(Object element) {
        String id;
        return element instanceof ISO9660Element && (id = (String)((ISO9660Element)element).getId()).equals("SA");
    }

    @Override
    public void data(DataReference reference) throws HandlerException {
        this.bytesWritten += reference.getLength();
        super.data(reference);
    }

    @Override
    public Fixup fixup(DataReference reference) throws HandlerException {
        this.bytesWritten += reference.getLength();
        return super.fixup(reference);
    }

    @Override
    public void endElement() throws HandlerException {
        Object element = this.elements.pop();
        if (element instanceof LogicalSectorElement) {
            int pad = (int)(2048L - this.bytesWritten % 2048L);
            super.data(new EmptyByteArrayDataReference(pad));
        } else if (this.isSAElement(element)) {
            int pad = (int)(32768L - this.bytesWritten % 16L * 2048L);
            super.data(new EmptyByteArrayDataReference(pad));
        }
        super.endElement();
    }

    @Override
    public void endDocument() throws HandlerException {
        if (this.padEnd) {
            int pad = (int)(307200L - this.bytesWritten % 16L * 2048L);
            super.data(new EmptyByteArrayDataReference(pad));
        }
        super.endDocument();
    }
}

