/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.joliet.impl;

import com.github.stephenc.javaisotools.iso9660.FilenameDataReference;
import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.joliet.impl.JolietFilenameDataReference;
import com.github.stephenc.javaisotools.joliet.impl.JolietNamingConventions;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.io.UnsupportedEncodingException;

public class JolietLayoutHelper
extends LayoutHelper {
    public JolietLayoutHelper(StreamHandler streamHandler, ISO9660RootDirectory root, int maxCharsInFilename, boolean failOnTruncation) {
        super(streamHandler, root, new JolietNamingConventions(maxCharsInFilename, failOnTruncation));
    }

    @Override
    public FilenameDataReference getFilenameDataReference(ISO9660Directory dir) throws HandlerException {
        return new JolietFilenameDataReference(dir);
    }

    @Override
    public FilenameDataReference getFilenameDataReference(ISO9660File file) throws HandlerException {
        return new JolietFilenameDataReference(file);
    }

    @Override
    public byte[] pad(String string, int targetByteLength) throws HandlerException {
        byte[] bytes = new byte[targetByteLength];
        byte[] original = null;
        int length = 0;
        try {
            int i2;
            if (string != null) {
                original = string.getBytes("UTF-16BE");
                length = original.length;
            }
            for (i2 = 0; i2 < length; ++i2) {
                bytes[i2] = original[i2];
            }
            for (i2 = length; i2 < bytes.length; ++i2) {
                bytes[i2] = 0;
                if (++i2 >= bytes.length) continue;
                bytes[i2] = 32;
            }
            bytes[bytes.length - 1] = 0;
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return bytes;
    }
}

