/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.rockridge.impl;

public class POSIXFileMode {
    public static final int USER_READ = 256;
    public static final int USER_WRITE = 128;
    public static final int USER_EXEC = 64;
    public static final int GROUP_READ = 32;
    public static final int GROUP_WRITE = 16;
    public static final int GROUP_EXEC = 8;
    public static final int OTHER_READ = 4;
    public static final int OTHER_WRITE = 2;
    public static final int OTHER_EXEC = 1;
    public static final int SETUID = 2048;
    public static final int SETGID = 1024;
    public static final int ENFORCE_FILE_LOCKING = 1024;
    public static final int SAVE_SWAPPED_AFTER_USE = 512;
    public static final int TYPE_OF_FILE = 61440;
    public static final int SOCKET = 49152;
    public static final int SYMLINK = 40960;
    public static final int REGULAR = 32768;
    public static final int BLOCK_SPECIAL = 24576;
    public static final int CHAR_SPECIAL = 8192;
    public static final int DIRECTORY = 16384;
    public static final int PIPE_FIFO = 4096;
    private int fileMode;

    public POSIXFileMode() {
        this.init();
    }

    public void init() {
        this.fileMode = 0;
    }

    public void initType() {
        this.fileMode &= 0xFFF;
    }

    public void setDefault(boolean isDirectory) {
        this.init();
        this.setPermission(256);
        this.setPermission(32);
        this.setPermission(4);
        if (isDirectory) {
            this.setPermission(16384);
            this.setPermission(64);
            this.setPermission(8);
            this.setPermission(1);
        } else {
            this.setPermission(32768);
        }
    }

    public void setFile() {
        this.initType();
        this.setPermission(32768);
    }

    public void setSymlink() {
        this.initType();
        this.setPermission(40960);
    }

    public void setDirectory() {
        this.initType();
        this.setPermission(16384);
    }

    public void setUID() {
        this.setPermission(2048);
    }

    public void setGID() {
        this.setPermission(1024);
    }

    public void setPermission(int permission) {
        this.fileMode |= permission;
    }

    public void clearPermission(int permission) {
        this.fileMode &= ~permission;
    }

    public int getFileMode() {
        return this.fileMode;
    }
}

