/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.rockridge.impl;

import com.github.stephenc.javaisotools.iso9660.sabre.impl.BothWordDataReference;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.EmptyByteArrayDataReference;
import com.github.stephenc.javaisotools.rockridge.impl.SystemUseEntryElement;
import com.github.stephenc.javaisotools.rockridge.impl.SystemUseEntryHandler;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteDataReference;
import java.util.HashMap;

public class SUSPFactory {
    public static final int CE_ENTRY_LENGTH = 28;
    StreamHandler streamHandler;

    public SUSPFactory(StreamHandler streamHandler) {
        this.streamHandler = new SystemUseEntryHandler(streamHandler, streamHandler);
    }

    public HashMap doCEEntry() throws HandlerException {
        HashMap<String, Fixup> memory = new HashMap<String, Fixup>();
        this.streamHandler.startElement(new SystemUseEntryElement("CE", 1));
        Fixup ceLocationFixup = this.streamHandler.fixup(new BothWordDataReference(0L));
        memory.put("ceLocationFixup", ceLocationFixup);
        Fixup ceOffsetFixup = this.streamHandler.fixup(new BothWordDataReference(0L));
        memory.put("ceOffsetFixup", ceOffsetFixup);
        Fixup ceLengthFixup = this.streamHandler.fixup(new BothWordDataReference(0L));
        memory.put("ceLengthFixup", ceLengthFixup);
        this.streamHandler.endElement();
        return memory;
    }

    public void doPDEntry(int paddingLength) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("PD", 1));
        this.streamHandler.data(new EmptyByteArrayDataReference(paddingLength));
        this.streamHandler.endElement();
    }

    public void doSPEntry(int skipBytes) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("SP", 1));
        this.streamHandler.data(new ByteDataReference(190L));
        this.streamHandler.data(new ByteDataReference(239L));
        this.streamHandler.data(new ByteDataReference(skipBytes));
        this.streamHandler.endElement();
    }

    public void doSTEntry() throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("ST", 1));
        this.streamHandler.endElement();
    }

    public void doEREntry(DataReference id, DataReference descriptor, DataReference source, int version) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("ER", 1));
        this.streamHandler.data(new ByteDataReference(id.getLength()));
        this.streamHandler.data(new ByteDataReference(descriptor.getLength()));
        this.streamHandler.data(new ByteDataReference(source.getLength()));
        this.streamHandler.data(new ByteDataReference(version));
        this.streamHandler.data(id);
        if (descriptor.getLength() > 0L) {
            this.streamHandler.data(descriptor);
        }
        this.streamHandler.data(source);
        this.streamHandler.endElement();
    }

    public void doEREntry(DataReference id, DataReference source, int version) throws HandlerException {
        this.doEREntry(id, new EmptyByteArrayDataReference(0), source, version);
    }

    public void doESEntry(int sequenceNumber) throws HandlerException {
        this.streamHandler.startElement(new SystemUseEntryElement("ES", 1));
        this.streamHandler.data(new ByteDataReference(sequenceNumber));
        this.streamHandler.endElement();
    }
}

