/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.sabre.impl;

import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.FileFixup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class SerializingAtomHandler
implements StreamHandler {
    private File file = null;
    private RandomAccessFile randomAccessFile = null;
    private long position = 0L;

    public SerializingAtomHandler(File file) throws FileNotFoundException {
        this.file = file;
        this.randomAccessFile = new RandomAccessFile(this.file, "rw");
    }

    @Override
    public void startDocument() throws HandlerException {
        try {
            this.randomAccessFile.setLength(0L);
        }
        catch (IOException e2) {
            throw new HandlerException(e2);
        }
    }

    @Override
    public void startElement(Element element) throws HandlerException {
    }

    @Override
    public void data(DataReference reference) throws HandlerException {
        InputStream inputStream = null;
        byte[] buffer = null;
        int bytesToRead = 0;
        int bytesHandled = 0;
        int bufferLength = 65535;
        long lengthToWrite = 0L;
        long length = 0L;
        try {
            buffer = new byte[bufferLength];
            lengthToWrite = length = reference.getLength();
            inputStream = reference.createInputStream();
            this.randomAccessFile.seek(this.position);
            while (lengthToWrite > 0L) {
                bytesToRead = lengthToWrite > (long)bufferLength ? bufferLength : (int)lengthToWrite;
                bytesHandled = inputStream.read(buffer, 0, bytesToRead);
                if (bytesHandled == -1) {
                    throw new HandlerException("Cannot read all data from reference.");
                }
                this.randomAccessFile.write(buffer, 0, bytesHandled);
                lengthToWrite -= (long)bytesHandled;
                this.position += (long)bytesHandled;
            }
        }
        catch (IOException e2) {
            throw new HandlerException(e2);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Fixup fixup(DataReference reference) throws HandlerException {
        FileFixup fixup = null;
        fixup = new FileFixup(this.randomAccessFile, this.position, reference.getLength());
        this.data(reference);
        return fixup;
    }

    @Override
    public long mark() throws HandlerException {
        return this.position;
    }

    @Override
    public void endElement() throws HandlerException {
    }

    @Override
    public void endDocument() throws HandlerException {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException e2) {
            throw new HandlerException(e2);
        }
    }
}

