/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.sabre.impl;

import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLAtomHandler
implements StreamHandler {
    private ContentHandler contentHandler = null;
    private String namespace = null;
    private String prefix = null;
    private Stack elements = null;

    public XMLAtomHandler(ContentHandler contentHandler, String namespace, String prefix) {
        this.contentHandler = contentHandler;
        this.namespace = namespace;
        this.prefix = prefix;
        this.elements = new Stack();
    }

    @Override
    public void startDocument() throws HandlerException {
        try {
            this.contentHandler.startElement(this.namespace, "root", this.prefix + ":root", null);
        }
        catch (SAXException e2) {
            throw new HandlerException(e2);
        }
    }

    @Override
    public void startElement(Element element) throws HandlerException {
        try {
            this.elements.push(element);
            this.contentHandler.startElement(this.namespace, element.toString(), this.prefix + ":" + element.toString(), null);
        }
        catch (SAXException e2) {
            throw new HandlerException(e2);
        }
    }

    @Override
    public void data(DataReference reference) throws HandlerException {
        long showLength = 0L;
        try {
            InputStream inputStream = null;
            byte[] buffer = null;
            String data = null;
            long length = reference.getLength();
            showLength = length > 32L ? 32L : length;
            buffer = new byte[(int)showLength];
            inputStream = reference.createInputStream();
            inputStream.read(buffer);
            inputStream.close();
            data = new String(buffer);
            data = StringEscapeUtils.escapeJava(data);
            this.contentHandler.characters(data.toCharArray(), 0, data.length());
        }
        catch (SAXException e2) {
            throw new HandlerException(e2);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public Fixup fixup(DataReference reference) throws HandlerException {
        throw new HandlerException("Cannot handle fixup in SAX.");
    }

    @Override
    public long mark() throws HandlerException {
        throw new HandlerException("Cannot mark position in SAX.");
    }

    @Override
    public void endElement() throws HandlerException {
        Element element = null;
        try {
            element = (Element)this.elements.pop();
            this.contentHandler.endElement(this.namespace, element.toString(), this.prefix + ":" + element.toString());
        }
        catch (SAXException e2) {
            throw new HandlerException(e2);
        }
    }

    @Override
    public void endDocument() throws HandlerException {
        try {
            this.contentHandler.endElement(this.namespace, "root", this.prefix + ":root");
        }
        catch (SAXException e2) {
            throw new HandlerException(e2);
        }
    }
}

