/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy.iso9660;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import net.didion.loopy.AbstractBlockFileSystem;
import net.didion.loopy.FileEntry;
import net.didion.loopy.VolumeDescriptorSet;
import net.didion.loopy.iso9660.EntryEnumeration;
import net.didion.loopy.iso9660.EntryInputStream;
import net.didion.loopy.iso9660.ISO9660FileEntry;
import net.didion.loopy.iso9660.ISO9660VolumeDescriptorSet;

public class ISO9660FileSystem
extends AbstractBlockFileSystem {
    public ISO9660FileSystem(File file, boolean readOnly) throws IOException {
        super(file, readOnly, 2048, 16);
    }

    public String getEncoding() {
        return ((ISO9660VolumeDescriptorSet)this.getVolumeDescriptorSet()).getEncoding();
    }

    public InputStream getInputStream(FileEntry entry) {
        this.ensureOpen();
        return new EntryInputStream((ISO9660FileEntry)entry, this);
    }

    byte[] getBytes(ISO9660FileEntry entry) throws IOException {
        int size = entry.getSize();
        byte[] buf = new byte[size];
        this.readBytes(entry, 0, buf, 0, size);
        return buf;
    }

    int readBytes(ISO9660FileEntry entry, int entryOffset, byte[] buffer, int bufferOffset, int len) throws IOException {
        long startPos = entry.getStartBlock() * 2048L + (long)entryOffset;
        return this.readData(startPos, buffer, bufferOffset, len);
    }

    protected Enumeration enumerate(FileEntry rootEntry) {
        return new EntryEnumeration(this, (ISO9660FileEntry)rootEntry);
    }

    protected VolumeDescriptorSet createVolumeDescriptorSet() {
        return new ISO9660VolumeDescriptorSet(this);
    }
}

