/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.operations;

import java.util.ArrayList;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.operations.FileOperation;
import org.apache.commons.vfs.operations.FileOperationProvider;
import org.apache.commons.vfs.operations.FileOperations;

public class DefaultFileOperations
implements FileOperations {
    private FileSystemManager fsmanager;
    private FileObject fileObject;

    public DefaultFileOperations(FileObject file) {
        this.fileObject = file;
        this.fsmanager = file.getFileSystem().getFileSystemManager();
    }

    public Class[] getOperations() throws FileSystemException {
        String scheme = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] providers = this.fsmanager.getOperationProviders(scheme);
        if (providers == null) {
            return null;
        }
        ArrayList operations = new ArrayList();
        for (int i2 = 0; i2 < providers.length; ++i2) {
            FileOperationProvider provider = providers[i2];
            provider.collectOperations(operations, this.fileObject);
        }
        return operations.toArray(new Class[0]);
    }

    public FileOperation getOperation(Class operationClass) throws FileSystemException {
        FileOperationProvider provider;
        String scheme = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] providers = this.fsmanager.getOperationProviders(scheme);
        if (providers == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", operationClass);
        }
        FileOperation resultOperation = null;
        for (int i2 = 0; i2 < providers.length && (resultOperation = (provider = providers[i2]).getOperation(this.fileObject, operationClass)) == null; ++i2) {
        }
        if (resultOperation == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", operationClass);
        }
        return resultOperation;
    }

    public boolean hasOperation(Class operationClass) throws FileSystemException {
        Class[] operations = this.getOperations();
        if (operations == null) {
            return false;
        }
        for (int i2 = 0; i2 < operations.length; ++i2) {
            Class operation = operations[i2];
            if (!operationClass.isAssignableFrom(operation)) continue;
            return true;
        }
        return false;
    }
}

