/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.util.ArrayList;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractVfsComponent;
import org.apache.commons.vfs.provider.VfsComponent;

public abstract class AbstractVfsContainer
extends AbstractVfsComponent {
    private final ArrayList components = new ArrayList();

    protected void addComponent(Object component) throws FileSystemException {
        if (!this.components.contains(component)) {
            if (component instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)component;
                vfsComponent.setLogger(this.getLogger());
                vfsComponent.setContext(this.getContext());
                vfsComponent.init();
            }
            this.components.add(component);
        }
    }

    protected void removeComponent(Object component) {
        this.components.remove(component);
    }

    public void close() {
        int count = this.components.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Object component = this.components.get(i2);
            if (!(component instanceof VfsComponent)) continue;
            VfsComponent vfsComponent = (VfsComponent)component;
            vfsComponent.close();
        }
        this.components.clear();
    }
}

