/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.ftp.FtpClient;
import org.apache.commons.vfs.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs.provider.ftp.FtpRandomAccessContent;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.Messages;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

public class FtpFileObject
extends AbstractFileObject {
    private Log log = LogFactory.getLog(class$org$apache$commons$vfs$provider$ftp$FtpFileObject == null ? (class$org$apache$commons$vfs$provider$ftp$FtpFileObject = FtpFileObject.class$("org.apache.commons.vfs.provider.ftp.FtpFileObject")) : class$org$apache$commons$vfs$provider$ftp$FtpFileObject);
    private static final Map EMPTY_FTP_FILE_MAP = Collections.unmodifiableMap(new TreeMap());
    private final FtpFileSystem ftpFs;
    private final String relPath;
    private FTPFile fileInfo;
    private Map children;
    private FileObject linkDestination;
    private boolean inRefresh = false;
    static /* synthetic */ Class class$org$apache$commons$vfs$provider$ftp$FtpFileObject;

    protected FtpFileObject(FileName name, FtpFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, fileSystem);
        this.ftpFs = fileSystem;
        String relPath = UriParser.decode(rootName.getRelativeName(name));
        this.relPath = ".".equals(relPath) ? null : relPath;
    }

    private FTPFile getChildFile(String name, boolean flush) throws IOException {
        if (flush) {
            this.children = null;
        }
        this.doGetChildren();
        FTPFile ftpFile = (FTPFile)this.children.get(name);
        return ftpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        FtpClient client = this.ftpFs.getClient();
        try {
            FTPFile[] tmpChildren = client.listFiles(this.relPath);
            if (tmpChildren == null || tmpChildren.length == 0) {
                this.children = EMPTY_FTP_FILE_MAP;
            } else {
                this.children = new TreeMap();
                for (int i2 = 0; i2 < tmpChildren.length; ++i2) {
                    FTPFile child = tmpChildren[i2];
                    if (child == null) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug(Messages.getString("vfs.provider.ftp/invalid-directory-entry.debug", new Object[]{new Integer(i2), this.relPath}));
                        continue;
                    }
                    if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
                    this.children.put(child.getName(), child);
                }
            }
        }
        finally {
            this.ftpFs.putClient(client);
        }
    }

    protected void doAttach() throws IOException {
        this.getInfo(false);
    }

    private void getInfo(boolean flush) throws IOException {
        FTPFile newFileInfo;
        FtpFileObject parent = (FtpFileObject)FileObjectUtils.getAbstractFileObject(this.getParent());
        if (parent != null) {
            newFileInfo = parent.getChildFile(UriParser.decode(this.getName().getBaseName()), flush);
        } else {
            newFileInfo = new FTPFile();
            newFileInfo.setType(1);
        }
        this.fileInfo = newFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                try {
                    this.getInfo(true);
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    protected void doDetach() {
        this.fileInfo = null;
        this.children = null;
    }

    protected void onChildrenChanged(FileName child, FileType newType) {
        if (this.children != null && newType.equals(FileType.IMAGINARY)) {
            try {
                this.children.remove(UriParser.decode(child.getBaseName()));
            }
            catch (FileSystemException e2) {
                throw new RuntimeException(e2.getMessage());
            }
        } else {
            this.children = null;
        }
    }

    protected void onChange() throws IOException {
        this.children = null;
        if (this.getType().equals(FileType.IMAGINARY)) {
            this.fileInfo = null;
            return;
        }
        this.getInfo(true);
    }

    protected FileType doGetType() throws Exception {
        if (this.fileInfo == null) {
            return FileType.IMAGINARY;
        }
        if (this.fileInfo.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.fileInfo.isFile()) {
            return FileType.FILE;
        }
        if (this.fileInfo.isSymbolicLink()) {
            return this.getLinkDestination().getType();
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", this.getName());
    }

    private FileObject getLinkDestination() throws FileSystemException {
        if (this.linkDestination == null) {
            String path = this.fileInfo.getLink();
            FileName relativeTo = this.getName().getParent();
            if (relativeTo == null) {
                relativeTo = this.getName();
            }
            FileName linkDestinationName = this.getFileSystem().getFileSystemManager().resolveName(relativeTo, path);
            this.linkDestination = this.getFileSystem().resolveFile(linkDestinationName);
        }
        return this.linkDestination;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        if (this.fileInfo.isSymbolicLink()) {
            return this.getLinkDestination().getChildren();
        }
        return null;
    }

    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        String[] childNames = new String[this.children.size()];
        int childNum = -1;
        Iterator iterChildren = this.children.values().iterator();
        while (iterChildren.hasNext()) {
            FTPFile child = (FTPFile)iterChildren.next();
            childNames[++childNum] = child.getName();
        }
        return UriParser.encode(childNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        boolean ok;
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            ok = this.fileInfo.isDirectory() ? ftpClient.removeDirectory(this.relPath) : ftpClient.deleteFile(this.relPath);
        }
        finally {
            this.ftpFs.putClient(ftpClient);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/delete-file.error", this.getName());
        }
        this.fileInfo = null;
        this.children = EMPTY_FTP_FILE_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        boolean ok;
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            String oldName = this.getName().getPath();
            String newName = newfile.getName().getPath();
            ok = ftpClient.rename(oldName, newName);
        }
        finally {
            this.ftpFs.putClient(ftpClient);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/rename-file.error", new Object[]{this.getName().toString(), newfile});
        }
        this.fileInfo = null;
        this.children = EMPTY_FTP_FILE_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        boolean ok;
        FtpClient client = this.ftpFs.getClient();
        try {
            ok = client.makeDirectory(this.relPath);
        }
        finally {
            this.ftpFs.putClient(client);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/create-folder.error", this.getName());
        }
    }

    protected long doGetContentSize() throws Exception {
        if (this.fileInfo.isSymbolicLink()) {
            return this.getLinkDestination().getContent().getSize();
        }
        return this.fileInfo.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.fileInfo.isSymbolicLink()) {
            return this.getLinkDestination().getContent().getLastModifiedTime();
        }
        Calendar timestamp = this.fileInfo.getTimestamp();
        if (timestamp == null) {
            return 0L;
        }
        return timestamp.getTime().getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        FtpClient client = this.ftpFs.getClient();
        InputStream instr = client.retrieveFileStream(this.relPath);
        return new FtpInputStream(client, instr);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new FtpRandomAccessContent(this, mode);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        FtpClient client = this.ftpFs.getClient();
        OutputStream out = null;
        out = bAppend ? client.appendFileStream(this.relPath) : client.storeFileStream(this.relPath);
        if (out == null) {
            throw new FileSystemException("vfs.provider.ftp/output-error.debug", new Object[]{this.getName(), client.getReplyString()});
        }
        return new FtpOutputStream(client, out);
    }

    String getRelPath() {
        return this.relPath;
    }

    FtpInputStream getInputStream(long filePointer) throws IOException {
        FtpClient client = this.ftpFs.getClient();
        InputStream instr = client.retrieveFileStream(this.relPath, filePointer);
        if (instr == null) {
            throw new FileSystemException("vfs.provider.ftp/input-error.debug", new Object[]{this.getName(), client.getReplyString()});
        }
        return new FtpInputStream(client, instr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FtpOutputStream
    extends MonitorOutputStream {
        private final FtpClient client;

        public FtpOutputStream(FtpClient client, OutputStream outstr) {
            super(outstr);
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-put.error", FtpFileObject.this.getName());
            }
        }
    }

    class FtpInputStream
    extends MonitorInputStream {
        private final FtpClient client;

        public FtpInputStream(FtpClient client, InputStream in) {
            super(in);
            this.client = client;
        }

        void abort() throws IOException {
            this.client.abort();
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-get.error", FtpFileObject.this.getName());
            }
        }
    }
}

