/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.local.LocalFileRandomAccessContent;
import org.apache.commons.vfs.provider.local.LocalFileSystem;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.RandomAccessMode;

public class LocalFile
extends AbstractFileObject
implements FileObject {
    private final String rootFile;
    private File file;
    static /* synthetic */ Class class$org$apache$commons$vfs$provider$local$LocalFile;

    protected LocalFile(LocalFileSystem fileSystem, String rootFile, FileName name) throws FileSystemException {
        super(name, fileSystem);
        this.rootFile = rootFile;
    }

    protected File getLocalFile() {
        return this.file;
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            String fileName = this.rootFile + this.getName().getPathDecoded();
            this.file = new File(fileName);
        }
    }

    protected FileType doGetType() throws Exception {
        if (!this.file.exists() && this.file.length() < 1L) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() throws Exception {
        return UriParser.encode(this.file.list());
    }

    protected void doDelete() throws Exception {
        if (!this.file.delete()) {
            throw new FileSystemException("vfs.provider.local/delete-file.error", this.file);
        }
    }

    protected void doRename(FileObject newfile) throws Exception {
        LocalFile newLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject(newfile);
        if (!this.file.renameTo(newLocalFile.getLocalFile())) {
            throw new FileSystemException("vfs.provider.local/rename-file.error", new String[]{this.file.toString(), newfile.toString()});
        }
    }

    protected void doCreateFolder() throws Exception {
        if (!this.file.mkdirs()) {
            throw new FileSystemException("vfs.provider.local/create-folder.error", this.file);
        }
    }

    protected boolean doIsWriteable() throws FileSystemException {
        return this.file.canWrite();
    }

    protected boolean doIsHidden() {
        return this.file.isHidden();
    }

    protected boolean doIsReadable() throws FileSystemException {
        return this.file.canRead();
    }

    protected long doGetLastModifiedTime() throws FileSystemException {
        return this.file.lastModified();
    }

    protected void doSetLastModifiedTime(long modtime) throws FileSystemException {
        this.file.setLastModified(modtime);
    }

    protected InputStream doGetInputStream() throws Exception {
        return new FileInputStream(this.file);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new FileOutputStream(this.file.getPath(), bAppend);
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new LocalFileRandomAccessContent(this.file, mode);
    }

    protected boolean doIsSameFile(FileObject destFile) throws FileSystemException {
        if (!FileObjectUtils.isInstanceOf(destFile, class$org$apache$commons$vfs$provider$local$LocalFile == null ? (class$org$apache$commons$vfs$provider$local$LocalFile = LocalFile.class$("org.apache.commons.vfs.provider.local.LocalFile")) : class$org$apache$commons$vfs$provider$local$LocalFile)) {
            return false;
        }
        LocalFile destLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject(destFile);
        if (!this.exists() || !destLocalFile.exists()) {
            return false;
        }
        try {
            return this.file.getCanonicalPath().equals(destLocalFile.file.getCanonicalPath());
        }
        catch (IOException e2) {
            throw new FileSystemException(e2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

