/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs.provider.sftp.SftpFileObject;
import org.apache.commons.vfs.util.RandomAccessMode;

class SftpRandomAccessContent
extends AbstractRandomAccessStreamContent {
    private final SftpFileObject fileObject;
    protected long filePointer = 0L;
    private DataInputStream dis = null;
    private InputStream mis = null;

    SftpRandomAccessContent(SftpFileObject fileObject, RandomAccessMode mode) {
        super(mode);
        this.fileObject = fileObject;
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", new Object[]{new Long(pos)});
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = pos;
    }

    protected DataInputStream getDataInputStream() throws IOException {
        if (this.dis != null) {
            return this.dis;
        }
        this.mis = this.fileObject.getInputStream(this.filePointer);
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++SftpRandomAccessContent.this.filePointer;
                }
                return ret;
            }

            public int read(byte[] b2) throws IOException {
                int ret = super.read(b2);
                if (ret > -1) {
                    SftpRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            public int read(byte[] b2, int off, int len) throws IOException {
                int ret = super.read(b2, off, len);
                if (ret > -1) {
                    SftpRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            public void close() throws IOException {
                SftpRandomAccessContent.this.close();
            }
        });
        return this.dis;
    }

    public void close() throws IOException {
        if (this.dis != null) {
            this.mis.close();
            DataInputStream oldDis = this.dis;
            this.dis = null;
            oldDis.close();
            this.mis = null;
        }
    }

    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

