/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

class TarUtils {
    TarUtils() {
    }

    public static int getCheckSumOctalBytes(long value, byte[] buf, int offset, int length) {
        TarUtils.getOctalBytes(value, buf, offset, length);
        buf[offset + length - 1] = 32;
        buf[offset + length - 2] = 0;
        return offset + length;
    }

    public static int getLongOctalBytes(long value, byte[] buf, int offset, int length) {
        byte[] temp = new byte[length + 1];
        TarUtils.getOctalBytes(value, temp, 0, length + 1);
        System.arraycopy(temp, 0, buf, offset, length);
        return offset + length;
    }

    public static int getNameBytes(StringBuffer name, byte[] buffer, int offset, int length) {
        int i2;
        for (i2 = 0; i2 < length && i2 < name.length(); ++i2) {
            buffer[offset + i2] = (byte)name.charAt(i2);
        }
        while (i2 < length) {
            buffer[offset + i2] = 0;
            ++i2;
        }
        return offset + length;
    }

    public static int getOctalBytes(long value, byte[] buffer, int offset, int length) {
        int idx = length - 1;
        buffer[offset + idx] = 0;
        buffer[offset + --idx] = 32;
        --idx;
        if (value == 0L) {
            buffer[offset + idx] = 48;
            --idx;
        } else {
            for (long val = value; idx >= 0 && val > 0L; val >>= 3, --idx) {
                buffer[offset + idx] = (byte)(48 + (byte)(val & 7L));
            }
        }
        while (idx >= 0) {
            buffer[offset + idx] = 32;
            --idx;
        }
        return offset + length;
    }

    public static long computeCheckSum(byte[] buffer) {
        long sum = 0L;
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            sum += (long)(0xFF & buffer[i2]);
        }
        return sum;
    }

    public static StringBuffer parseName(byte[] header, int offset, int length) {
        StringBuffer result = new StringBuffer(length);
        int end = offset + length;
        for (int i2 = offset; i2 < end && header[i2] != 0; ++i2) {
            result.append((char)header[i2]);
        }
        return result;
    }

    public static long parseOctal(byte[] header, int offset, int length) {
        long result = 0L;
        boolean stillPadding = true;
        int end = offset + length;
        for (int i2 = offset; i2 < end && header[i2] != 0; ++i2) {
            if (header[i2] == 32 || header[i2] == 48) {
                if (stillPadding) continue;
                if (header[i2] == 32) break;
            }
            stillPadding = false;
            result = (result << 3) + (long)(header[i2] - 48);
        }
        return result;
    }
}

