/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.res.ResourceFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.url.UrlFileNameParser;
import org.apache.commons.vfs.provider.url.UrlFileSystem;

public class UrlFileProvider
extends AbstractFileProvider {
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED));

    public UrlFileProvider() {
        this.setFileNameParser(new UrlFileNameParser());
    }

    public synchronized FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        try {
            URL url = new URL(uri);
            URL rootUrl = new URL(url, "/");
            String key = this.getClass().getName() + rootUrl.toString();
            FileSystem fs = this.findFileSystem((Comparable)((Object)key), fileSystemOptions);
            if (fs == null) {
                String extForm = rootUrl.toExternalForm();
                FileName rootName = this.getContext().parseURI(extForm);
                fs = new UrlFileSystem(rootName, fileSystemOptions);
                this.addFileSystem((Comparable)((Object)key), fs);
            }
            return fs.resolveFile(url.getPath());
        }
        catch (MalformedURLException e2) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", uri, (Throwable)e2);
        }
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

