/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.zip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.zip.ZipFileObject;
import org.apache.commons.vfs.provider.zip.ZipFileProvider;

public class ZipFileSystem
extends AbstractFileSystem
implements FileSystem {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$vfs$provider$zip$ZipFileSystem == null ? (class$org$apache$commons$vfs$provider$zip$ZipFileSystem = ZipFileSystem.class$("org.apache.commons.vfs.provider.zip.ZipFileSystem")) : class$org$apache$commons$vfs$provider$zip$ZipFileSystem);
    private final File file;
    private ZipFile zipFile;
    static /* synthetic */ Class class$org$apache$commons$vfs$provider$zip$ZipFileSystem;

    public ZipFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, parentLayer, fileSystemOptions);
        this.file = parentLayer.getFileSystem().replicateFile(parentLayer, Selectors.SELECT_SELF);
        if (!this.file.exists()) {
            this.zipFile = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws FileSystemException {
        super.init();
        try {
            ArrayList<ZipFileObject> strongRef = new ArrayList<ZipFileObject>(100);
            Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
            while (entries.hasMoreElements()) {
                ZipFileObject fileObj;
                ZipEntry entry = entries.nextElement();
                FileName name = this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode(entry.getName()));
                if (entry.isDirectory() && this.getFileFromCache(name) != null) {
                    fileObj = (ZipFileObject)this.getFileFromCache(name);
                    fileObj.setZipEntry(entry);
                    continue;
                }
                fileObj = this.createZipFileObject(name, entry);
                this.putFileToCache(fileObj);
                strongRef.add(fileObj);
                fileObj.holdObject(strongRef);
                ZipFileObject parent = null;
                for (FileName parentName = name.getParent(); parentName != null; parentName = parentName.getParent()) {
                    parent = (ZipFileObject)this.getFileFromCache(parentName);
                    if (parent == null) {
                        parent = this.createZipFileObject(parentName, null);
                        this.putFileToCache(parent);
                        strongRef.add(parent);
                        parent.holdObject(strongRef);
                    }
                    parent.attachChild(fileObj.getName());
                    fileObj = parent;
                }
            }
        }
        finally {
            this.closeCommunicationLink();
        }
    }

    protected ZipFile getZipFile() throws FileSystemException {
        if (this.zipFile == null && this.file.exists()) {
            ZipFile zipFile;
            this.zipFile = zipFile = this.createZipFile(this.file);
        }
        return this.zipFile;
    }

    protected ZipFileObject createZipFileObject(FileName name, ZipEntry entry) throws FileSystemException {
        return new ZipFileObject(name, entry, this, true);
    }

    protected ZipFile createZipFile(File file) throws FileSystemException {
        try {
            return new ZipFile(file);
        }
        catch (IOException ioe) {
            throw new FileSystemException("vfs.provider.zip/open-zip-file.error", file, (Throwable)ioe);
        }
    }

    protected void doCloseCommunicationLink() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException e2) {
            VfsLog.warn(this.getLogger(), log, "vfs.provider.zip/close-zip-file.error :" + this.file, e2);
        }
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(ZipFileProvider.capabilities);
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new ZipFileObject(name, null, this, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

