/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.el.impl.lang;

import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdesktop.el.ELContext;
import org.jdesktop.el.ELException;
import org.jdesktop.el.FunctionMapper;
import org.jdesktop.el.MethodExpression;
import org.jdesktop.el.ValueExpression;
import org.jdesktop.el.VariableMapper;
import org.jdesktop.el.impl.MethodExpressionImpl;
import org.jdesktop.el.impl.MethodExpressionLiteral;
import org.jdesktop.el.impl.ValueExpressionImpl;
import org.jdesktop.el.impl.lang.FunctionMapperFactory;
import org.jdesktop.el.impl.lang.VariableMapperFactory;
import org.jdesktop.el.impl.parser.AstCompositeExpression;
import org.jdesktop.el.impl.parser.AstDeferredExpression;
import org.jdesktop.el.impl.parser.AstDynamicExpression;
import org.jdesktop.el.impl.parser.AstFunction;
import org.jdesktop.el.impl.parser.AstIdentifier;
import org.jdesktop.el.impl.parser.AstLiteralExpression;
import org.jdesktop.el.impl.parser.AstValue;
import org.jdesktop.el.impl.parser.ELParser;
import org.jdesktop.el.impl.parser.Node;
import org.jdesktop.el.impl.parser.NodeVisitor;
import org.jdesktop.el.impl.parser.ParseException;
import org.jdesktop.el.impl.util.MessageFactory;

public final class ExpressionBuilder
implements NodeVisitor {
    private static final int SIZE = 5000;
    private static final Map cache = new ConcurrentHashMap(5000);
    private static final Map cache2 = new ConcurrentHashMap(5000);
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private String expression;

    public ExpressionBuilder(String expression, ELContext ctx) throws ELException {
        this.expression = expression;
        FunctionMapper ctxFn = ctx.getFunctionMapper();
        VariableMapper ctxVar = ctx.getVariableMapper();
        if (ctxFn != null) {
            this.fnMapper = new FunctionMapperFactory(ctxFn);
        }
        if (ctxVar != null) {
            this.varMapper = new VariableMapperFactory(ctxVar);
        }
    }

    public static final Node createNode(String expr) throws ELException {
        Node n2 = ExpressionBuilder.createNodeInternal(expr);
        return n2;
    }

    private static final Node createNodeInternal(String expr) throws ELException {
        if (expr == null) {
            throw new ELException(MessageFactory.get("error.null"));
        }
        Node n2 = (Node)cache.get(expr);
        if (n2 == null && (n2 = (Node)cache2.get(expr)) == null) {
            try {
                n2 = new ELParser(new StringReader(expr)).CompositeExpression();
                if (n2 instanceof AstCompositeExpression) {
                    int numChildren = n2.jjtGetNumChildren();
                    if (numChildren == 1) {
                        n2 = n2.jjtGetChild(0);
                    } else {
                        Class<?> type = null;
                        Node child = null;
                        for (int i2 = 0; i2 < numChildren; ++i2) {
                            child = n2.jjtGetChild(i2);
                            if (child instanceof AstLiteralExpression) continue;
                            if (type == null) {
                                type = child.getClass();
                                continue;
                            }
                            if (type.equals(child.getClass())) continue;
                            throw new ELException(MessageFactory.get("error.mixed", expr));
                        }
                    }
                }
                if (n2 instanceof AstDeferredExpression || n2 instanceof AstDynamicExpression) {
                    n2 = n2.jjtGetChild(0);
                }
                if (cache.size() > 5000) {
                    cache2.clear();
                    cache2.putAll(cache);
                    cache.clear();
                }
                cache.put(expr, n2);
            }
            catch (ParseException pe) {
                throw new ELException("Error Parsing: " + expr, pe);
            }
        }
        return n2;
    }

    private void prepare(Node node) throws ELException {
        node.accept(this);
        if (this.fnMapper instanceof FunctionMapperFactory) {
            this.fnMapper = ((FunctionMapperFactory)this.fnMapper).create();
        }
        if (this.varMapper instanceof VariableMapperFactory) {
            this.varMapper = ((VariableMapperFactory)this.varMapper).create();
        }
    }

    private Node build() throws ELException {
        Node n2 = ExpressionBuilder.createNodeInternal(this.expression);
        this.prepare(n2);
        if (n2 instanceof AstDeferredExpression || n2 instanceof AstDynamicExpression) {
            n2 = n2.jjtGetChild(0);
        }
        return n2;
    }

    public void visit(Node node) throws ELException {
        if (node instanceof AstFunction) {
            AstFunction funcNode = (AstFunction)node;
            if (this.fnMapper == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.null"));
            }
            Method m2 = this.fnMapper.resolveFunction(funcNode.getPrefix(), funcNode.getLocalName());
            if (m2 == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.method", funcNode.getOutputName()));
            }
            int pcnt = m2.getParameterTypes().length;
            if (node.jjtGetNumChildren() != pcnt) {
                throw new ELException(MessageFactory.get("error.fnMapper.paramcount", funcNode.getOutputName(), "" + pcnt, "" + node.jjtGetNumChildren()));
            }
        } else if (node instanceof AstIdentifier && this.varMapper != null) {
            String variable = ((AstIdentifier)node).getImage();
            this.varMapper.resolveVariable(variable);
        }
    }

    public ValueExpression createValueExpression(Class expectedType) throws ELException {
        Node n2 = this.build();
        return new ValueExpressionImpl(this.expression, n2, this.fnMapper, this.varMapper, expectedType);
    }

    public MethodExpression createMethodExpression(Class expectedReturnType, Class[] expectedParamTypes) throws ELException {
        Node n2 = this.build();
        if (n2 instanceof AstValue || n2 instanceof AstIdentifier) {
            return new MethodExpressionImpl(this.expression, n2, this.fnMapper, this.varMapper, expectedReturnType, expectedParamTypes);
        }
        if (n2 instanceof AstLiteralExpression) {
            return new MethodExpressionLiteral(this.expression, expectedReturnType, expectedParamTypes);
        }
        throw new ELException("Not a Valid Method Expression: " + this.expression);
    }
}

