/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.CalendarState;
import org.jdesktop.swingx.renderer.CellContext;

class CalendarCellContext
extends CellContext {
    private int arrowPaddingX = 3;
    private int arrowPaddingY = 3;
    private CalendarState dayState;

    CalendarCellContext() {
    }

    public void installContext(JXMonthView component, Calendar value, boolean selected, boolean focused, CalendarState dayState) {
        this.component = component;
        this.dayState = dayState;
        this.installState(value, -1, -1, selected, focused, true, true);
    }

    public JXMonthView getComponent() {
        return (JXMonthView)super.getComponent();
    }

    public CalendarState getCalendarState() {
        return this.dayState;
    }

    public Calendar getCalendar() {
        return this.getValue() instanceof Calendar ? (Calendar)this.getValue() : null;
    }

    protected Color getForeground() {
        Color flaggedOrPerDayForeground;
        Color weekOfTheYearForeground;
        if (CalendarState.LEADING == this.dayState) {
            return this.getUIColor("leadingDayForeground");
        }
        if (CalendarState.TRAILING == this.dayState) {
            return this.getUIColor("trailingDayForeground");
        }
        if (CalendarState.TITLE == this.dayState && this.getComponent() != null) {
            return this.getComponent().getMonthStringForeground();
        }
        if (CalendarState.WEEK_OF_YEAR == this.dayState && (weekOfTheYearForeground = this.getUIColor("weekOfTheYearForeground")) != null) {
            return weekOfTheYearForeground;
        }
        if (CalendarState.DAY_OF_WEEK == this.dayState) {
            Color daysOfTheWeekForeground;
            Color color = daysOfTheWeekForeground = this.getComponent() != null ? this.getComponent().getDaysOfTheWeekForeground() : null;
            if (daysOfTheWeekForeground != null) {
                return daysOfTheWeekForeground;
            }
        }
        return (flaggedOrPerDayForeground = this.getFlaggedOrPerDayForeground()) != null ? flaggedOrPerDayForeground : super.getForeground();
    }

    private Color getUIColor(String key) {
        return UIManagerExt.getColor(this.getUIPrefix() + key);
    }

    protected Color getFlaggedOrPerDayForeground() {
        if (this.getComponent() != null && this.getCalendar() != null) {
            if (this.getComponent().isFlaggedDate(this.getCalendar().getTime())) {
                return this.getComponent().getFlaggedDayForeground();
            }
            Color perDay = this.getComponent().getPerDayOfWeekForeground(this.getCalendar().get(7));
            if (perDay != null) {
                return perDay;
            }
        }
        return null;
    }

    protected Color getBackground() {
        if (CalendarState.TITLE == this.dayState && this.getComponent() != null) {
            return this.getComponent().getMonthStringBackground();
        }
        return super.getBackground();
    }

    protected Color getSelectionBackground() {
        if (CalendarState.LEADING == this.dayState || CalendarState.TRAILING == this.dayState) {
            return this.getBackground();
        }
        return this.getComponent() != null ? this.getComponent().getSelectionBackground() : null;
    }

    protected Color getSelectionForeground() {
        if (CalendarState.LEADING == this.dayState || CalendarState.TRAILING == this.dayState) {
            return this.getForeground();
        }
        Color flaggedOrPerDayForeground = this.getFlaggedOrPerDayForeground();
        if (flaggedOrPerDayForeground != null) {
            return flaggedOrPerDayForeground;
        }
        return this.getComponent() != null ? this.getComponent().getSelectionForeground() : null;
    }

    protected Border getBorder() {
        if (this.getComponent() == null) {
            return super.getBorder();
        }
        if (CalendarState.TITLE == this.dayState) {
            return this.getTitleBorder();
        }
        if (this.isToday()) {
            int x2 = this.getComponent().getBoxPaddingX();
            int y2 = this.getComponent().getBoxPaddingY();
            Border todayBorder = BorderFactory.createLineBorder(this.getComponent().getTodayBackground());
            Border empty = BorderFactory.createEmptyBorder(y2 - 1, x2 - 1, y2 - 1, x2 - 1);
            return BorderFactory.createCompoundBorder(todayBorder, empty);
        }
        return BorderFactory.createEmptyBorder(this.getComponent().getBoxPaddingY(), this.getComponent().getBoxPaddingX(), this.getComponent().getBoxPaddingY(), this.getComponent().getBoxPaddingX());
    }

    private Border getTitleBorder() {
        if (this.getComponent().isTraversable()) {
            Icon downIcon = UIManager.getIcon("JXMonthView.monthDownFileName");
            Icon upIcon = UIManager.getIcon("JXMonthView.monthUpFileName");
            IconBorder up = new IconBorder(upIcon, 3, this.arrowPaddingX);
            IconBorder down = new IconBorder(downIcon, 7, this.arrowPaddingX);
            CompoundBorder compound = BorderFactory.createCompoundBorder(up, down);
            Border empty = BorderFactory.createEmptyBorder(2 * this.arrowPaddingY, 0, 2 * this.arrowPaddingY, 0);
            return BorderFactory.createCompoundBorder(compound, empty);
        }
        return BorderFactory.createEmptyBorder(this.getComponent().getBoxPaddingY(), this.getComponent().getBoxPaddingX(), this.getComponent().getBoxPaddingY(), this.getComponent().getBoxPaddingX());
    }

    protected boolean isToday() {
        return CalendarState.TODAY == this.dayState;
    }

    protected String getUIPrefix() {
        return "JXMonthView.";
    }
}

