/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.prompt;

import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jdesktop.swingx.plaf.TextUIWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddySupport {
    public static final String OUTER_MARGIN = "outerMargin";

    public static void addLeft(Component c2, JTextField textField) {
        BuddySupport.add(c2, Position.LEFT, textField);
    }

    public static void addRight(Component c2, JTextField textField) {
        BuddySupport.add(c2, Position.RIGHT, textField);
    }

    public static void add(Component c2, Position pos, JTextField textField) {
        TextUIWrapper.getDefaultWrapper().install(textField, true);
        List<Component> leftBuddies = BuddySupport.buddies(Position.LEFT, textField);
        List<Component> rightBuddies = BuddySupport.buddies(Position.RIGHT, textField);
        BuddySupport.setLeft(textField, leftBuddies);
        BuddySupport.setRight(textField, rightBuddies);
        if (leftBuddies.contains(c2) || rightBuddies.contains(c2)) {
            throw new IllegalStateException("Component already added.");
        }
        if (Position.LEFT == pos) {
            leftBuddies.add(c2);
        } else {
            rightBuddies.add(0, c2);
        }
        BuddySupport.addToComponentHierarchy(c2, pos, textField);
    }

    public static void addGap(int width, Position pos, JTextField textField) {
        BuddySupport.add(BuddySupport.createGap(width), pos, textField);
    }

    public static void setRight(JTextField textField, List<Component> rightBuddies) {
        BuddySupport.set(rightBuddies, Position.RIGHT, textField);
    }

    public static void setLeft(JTextField textField, List<Component> leftBuddies) {
        BuddySupport.set(leftBuddies, Position.LEFT, textField);
    }

    public static void set(List<Component> buddies, Position pos, JTextField textField) {
        textField.putClientProperty((Object)pos, buddies);
    }

    private static void addToComponentHierarchy(Component c2, Position pos, JTextField textField) {
        textField.add(c2, pos.toString());
    }

    public static List<Component> getLeft(JTextField textField) {
        return BuddySupport.getBuddies(Position.LEFT, textField);
    }

    public static List<Component> getRight(JTextField textField) {
        return BuddySupport.getBuddies(Position.RIGHT, textField);
    }

    public static List<Component> getBuddies(Position pos, JTextField textField) {
        return Collections.unmodifiableList(BuddySupport.buddies(pos, textField));
    }

    private static List<Component> buddies(Position pos, JTextField textField) {
        List buddies = (List)textField.getClientProperty((Object)pos);
        if (buddies != null) {
            return buddies;
        }
        return new ArrayList<Component>();
    }

    public static boolean isBuddy(Component c2, JTextField textField) {
        return BuddySupport.buddies(Position.LEFT, textField).contains(c2) || BuddySupport.buddies(Position.RIGHT, textField).contains(c2);
    }

    public static void remove(JComponent c2, JTextField textField) {
        BuddySupport.buddies(Position.LEFT, textField).remove(c2);
        BuddySupport.buddies(Position.RIGHT, textField).remove(c2);
        textField.remove(c2);
    }

    public static void removeAll(JTextField textField) {
        List<Component> left = BuddySupport.buddies(Position.LEFT, textField);
        for (Component c2 : left) {
            textField.remove(c2);
        }
        left.clear();
        List<Component> right = BuddySupport.buddies(Position.RIGHT, textField);
        for (Component c3 : right) {
            textField.remove(c3);
        }
        right.clear();
    }

    public static void setOuterMargin(JTextField buddyField, Insets margin) {
        buddyField.putClientProperty(OUTER_MARGIN, margin);
    }

    public static Insets getOuterMargin(JTextField buddyField) {
        return (Insets)buddyField.getClientProperty(OUTER_MARGIN);
    }

    public static void ensureBuddiesAreInComponentHierarchy(JTextField textField) {
        for (Component c2 : BuddySupport.getLeft(textField)) {
            BuddySupport.addToComponentHierarchy(c2, Position.LEFT, textField);
        }
        for (Component c2 : BuddySupport.getRight(textField)) {
            BuddySupport.addToComponentHierarchy(c2, Position.RIGHT, textField);
        }
    }

    public static Component createGap(int width) {
        return Box.createHorizontalStrut(width);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        LEFT,
        RIGHT;

    }
}

