/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.search.AbstractSearchable;

public class TableSearchable
extends AbstractSearchable {
    protected JXTable table;

    public TableSearchable(JXTable table) {
        this.table = table;
    }

    protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
        AbstractSearchable.SearchResult matchRow = null;
        if (backwards) {
            for (int r2 = startRow; r2 >= -1 && matchRow == null; --r2) {
                matchRow = this.findMatchBackwardsInRow(pattern, r2);
                this.updateState(matchRow);
            }
        } else {
            for (int r3 = startRow; r3 <= this.getSize() && matchRow == null; ++r3) {
                matchRow = this.findMatchForwardInRow(pattern, r3);
                this.updateState(matchRow);
            }
        }
    }

    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
        return this.findMatchAt(pattern, row, this.lastSearchResult.foundColumn);
    }

    private AbstractSearchable.SearchResult findMatchForwardInRow(Pattern pattern, int row) {
        int startColumn;
        int n2 = startColumn = this.lastSearchResult.foundColumn < 0 ? 0 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(row)) {
            for (int column = startColumn; column < this.table.getColumnCount(); ++column) {
                AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private AbstractSearchable.SearchResult findMatchBackwardsInRow(Pattern pattern, int row) {
        int startColumn;
        int n2 = startColumn = this.lastSearchResult.foundColumn < 0 ? this.table.getColumnCount() - 1 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(row)) {
            for (int column = startColumn; column >= 0; --column) {
                AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row, int column) {
        Matcher matcher;
        String text = this.table.getStringAt(row, column);
        if (text != null && text.length() > 0 && (matcher = pattern.matcher(text)).find()) {
            return this.createSearchResult(matcher, row, column);
        }
        return null;
    }

    protected int adjustStartPosition(int startIndex, boolean backwards) {
        this.lastSearchResult.foundColumn = -1;
        return super.adjustStartPosition(startIndex, backwards);
    }

    protected int moveStartPosition(int startRow, boolean backwards) {
        if (backwards) {
            --this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn < 0) {
                --startRow;
            }
        } else {
            ++this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn >= this.table.getColumnCount()) {
                this.lastSearchResult.foundColumn = -1;
                ++startRow;
            }
        }
        return startRow;
    }

    protected boolean isEqualStartIndex(int startIndex) {
        return super.isEqualStartIndex(startIndex) && this.isValidColumn(this.lastSearchResult.foundColumn);
    }

    private boolean isValidColumn(int column) {
        return column >= 0 && column < this.table.getColumnCount();
    }

    protected int getSize() {
        return this.table.getRowCount();
    }

    public JXTable getTarget() {
        return this.table;
    }

    protected void moveMatchByHighlighter() {
        AbstractHighlighter searchHL = this.getConfiguredMatchHighlighter();
        if (!this.hasMatch()) {
            return;
        }
        this.ensureInsertedSearchHighlighters(searchHL);
        this.table.scrollCellToVisible(this.lastSearchResult.foundRow, this.lastSearchResult.foundColumn);
    }

    protected int convertColumnIndexToModel(int viewColumn) {
        return this.getTarget().convertColumnIndexToModel(viewColumn);
    }

    protected void moveMatchBySelection() {
        Rectangle cellRect;
        if (!this.hasMatch()) {
            return;
        }
        int row = this.lastSearchResult.foundRow;
        int column = this.lastSearchResult.foundColumn;
        this.table.changeSelection(row, column, false, false);
        if (!this.table.getAutoscrolls() && (cellRect = this.table.getCellRect(row, column, true)) != null) {
            this.table.scrollRectToVisible(cellRect);
        }
    }

    protected void moveMatchMarker() {
        if (this.markByHighlighter()) {
            this.moveMatchByHighlighter();
        } else {
            this.moveMatchBySelection();
        }
    }

    protected void removeHighlighter(Highlighter searchHighlighter) {
        this.table.removeHighlighter(searchHighlighter);
    }

    protected Highlighter[] getHighlighters() {
        return this.table.getHighlighters();
    }

    protected void addHighlighter(Highlighter highlighter) {
        this.table.addHighlighter(highlighter);
    }
}

